/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.project;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class Project {
    private ProjectInfo directory;
    private IFileStore projectInfoFile;
    private String name;
    public static final String ORION_PROJECT_FILE = ".orionProject";

    private Project(ProjectInfo directory, IFileStore projectInfoFile) throws CoreException {
        this.directory = directory;
        this.projectInfoFile = projectInfoFile;
        if (projectInfoFile == null) {
            return;
        }
        try {
            String projectInfoContent = IOUtilities.toString(this.projectInfoFile.openInputStream(0, null));
            this.initFromJson(projectInfoContent.trim().length() > 0 ? new JSONObject(projectInfoContent) : new JSONObject());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, "Could not read project information", e));
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, "Could not parse project information", e));
        }
    }

    public boolean exists() {
        return this.projectInfoFile != null;
    }

    public ProjectInfo getDirectory() {
        return this.directory;
    }

    public static Project fromProjectInfo(ProjectInfo projectInfo) throws CoreException {
        if (!projectInfo.getProjectStore().fetchInfo().exists()) {
            return new Project(projectInfo, null);
        }
        IFileStore projectInfoFile = projectInfo.getProjectStore().getChild(ORION_PROJECT_FILE);
        IFileInfo childInfo = projectInfoFile.fetchInfo();
        if (childInfo.exists()) {
            return new Project(projectInfo, projectInfoFile);
        }
        return new Project(projectInfo, null);
    }

    private void initFromJson(JSONObject projectInfo) {
        String name = projectInfo.optString("Name");
        this.name = name.length() == 0 ? this.directory.getFullName() : name;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject projectJson = new JSONObject();
        projectJson.put("Name", (Object)this.name);
        return projectJson;
    }
}

