/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.jobs.CloneJob;
import org.eclipse.orion.server.git.jobs.InitJob;
import org.eclipse.orion.server.git.jobs.PullJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitCloneHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitCloneHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        block9: {
            try {
                Path filePath = new Path(path);
                if (filePath.segmentCount() <= 0 || !filePath.segment(0).equals("file") || AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + filePath.toString()), (String)request.getMethod())) break block9;
                response.sendError(403);
                return true;
            }
            catch (Exception e) {
                String msg = NLS.bind((String)"Failed to handle /git/clone request for {0}", (Object)path);
                ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                LogHelper.log((IStatus)status);
                return this.statusHandler.handleRequest(request, response, (Object)status);
            }
        }
        switch (GitCloneHandlerV1.getMethod((HttpServletRequest)request)) {
            case GET: {
                return this.handleGet(request, response, path);
            }
            case PUT: {
                return this.handlePut(request, response, path);
            }
            case POST: {
                return this.handlePost(request, response, path);
            }
            case DELETE: {
                return this.handleDelete(request, response, path);
            }
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String pathString) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, NoHeadException, NoMessageException, ConcurrentRefUpdateException, WrongRepositoryStateException {
        Path filePath;
        boolean initOnly;
        JSONObject toAdd = OrionServlet.readJSONRequest((HttpServletRequest)request);
        if (toAdd.optBoolean("Pull", false)) {
            GitUtils.createGitCredentialsProvider(toAdd);
            GitCredentialsProvider cp = GitUtils.createGitCredentialsProvider(toAdd);
            boolean force = toAdd.optBoolean("Force", false);
            return this.pull(request, response, cp, pathString, force);
        }
        Clone clone = new Clone();
        String url = toAdd.optString("GitUrl", null);
        if (url == null || url.isEmpty()) {
            initOnly = true;
        } else {
            initOnly = false;
            if (!this.validateCloneUrl(url, request, response)) {
                return true;
            }
            clone.setUrl(new URIish(url));
        }
        String cloneName = toAdd.optString("Name", null);
        if (cloneName == null) {
            cloneName = request.getHeader("Slug");
        }
        String workspacePath = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)toAdd.optString("Location", null));
        String filePathString = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)toAdd.optString("Path", null));
        Path path = filePath = filePathString == null ? null : new Path(filePathString);
        if (filePath != null && filePath.segmentCount() < 3) {
            filePath = null;
        }
        if (filePath == null && workspacePath == null) {
            String msg = NLS.bind((String)"Either {0} or {1} should be provided: {2}", (Object[])new Object[]{"Path", "Location", toAdd});
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        if (initOnly && filePath == null && cloneName == null) {
            String msg = NLS.bind((String)"Either {0} or {1} should be provided: {2}", (Object[])new Object[]{"Path", "GitName", toAdd});
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        if (!this.validateCloneName(cloneName, request, response)) {
            return true;
        }
        ProjectInfo project = null;
        boolean webProjectExists = false;
        if (filePath != null) {
            clone.setId(filePath.toString());
            project = GitUtils.projectFromPath((IPath)filePath);
            if (project == null) {
                String msg = NLS.bind((String)"Specified project does not exist: {0}", (Object)filePath.segment(2));
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            webProjectExists = true;
            clone.setContentLocation(project.getProjectStore().getFileStore(filePath.removeFirstSegments(3)).toURI());
            if (cloneName == null) {
                cloneName = filePath.segmentCount() > 2 ? filePath.lastSegment() : project.getFullName();
            }
        } else if (workspacePath != null) {
            Path path2 = new Path(workspacePath);
            IMetaStore metaStore = OrionConfiguration.getMetaStore();
            WorkspaceInfo workspace = metaStore.readWorkspace(path2.segment(1));
            if (cloneName == null) {
                cloneName = new URIish(url).getHumanishName();
            }
            cloneName = this.getUniqueProjectName(workspace, cloneName);
            webProjectExists = false;
            project = new ProjectInfo();
            project.setFullName(cloneName);
            project.setWorkspaceId(workspace.getUniqueId());
            try {
                metaStore.createProject(project);
            }
            catch (CoreException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "Error persisting project state", (Throwable)e));
            }
            try {
                WorkspaceResourceHandler.computeProjectLocation((HttpServletRequest)request, (ProjectInfo)project, null, (boolean)false);
                metaStore.updateProject(project);
            }
            catch (CoreException e) {
                try {
                    metaStore.deleteProject(workspace.getUniqueId(), project.getFullName());
                }
                catch (CoreException e1) {
                    LogHelper.log((Throwable)e1);
                }
                String msg = NLS.bind((String)"Failed to create project: {0}", (Object)project.getFullName());
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            }
            URI baseLocation = GitCloneHandlerV1.getURI((HttpServletRequest)request);
            baseLocation = new URI(baseLocation.getScheme(), baseLocation.getUserInfo(), baseLocation.getHost(), baseLocation.getPort(), workspacePath, baseLocation.getQuery(), baseLocation.getFragment());
            clone.setId(GitUtils.pathFromProject(workspace, project).toString());
            clone.setContentLocation(project.getProjectStore().toURI());
        }
        clone.setName(cloneName);
        clone.setBaseLocation(GitCloneHandlerV1.getURI((HttpServletRequest)request));
        JSONObject cloneObject = clone.toJSON();
        String cloneLocation = cloneObject.getString("Location");
        String gitUserName = toAdd.optString("GitName", null);
        String gitUserMail = toAdd.optString("GitMail", null);
        Boolean initProject = toAdd.optBoolean("initProject", false);
        if (initOnly) {
            InitJob job = new InitJob(clone, TaskJobHandler.getUserId((HttpServletRequest)request), request.getRemoteUser(), cloneLocation, gitUserName, gitUserMail);
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
        }
        GitCredentialsProvider cp = GitUtils.createGitCredentialsProvider(toAdd);
        cp.setUri(new URIish(clone.getUrl()));
        CloneJob job = new CloneJob(clone, TaskJobHandler.getUserId((HttpServletRequest)request), (CredentialsProvider)cp, request.getRemoteUser(), cloneLocation, webProjectExists ? null : project, gitUserName, gitUserMail, initProject);
        return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
    }

    private String getUniqueProjectName(WorkspaceInfo workspace, String cloneName) {
        int i = 1;
        String uniqueName = cloneName;
        IMetaStore store = OrionConfiguration.getMetaStore();
        try {
            while (store.readProject(workspace.getUniqueId(), uniqueName) != null) {
                uniqueName = String.valueOf(cloneName) + '-' + ++i;
            }
        }
        catch (CoreException coreException) {}
        return uniqueName;
    }

    public static void doConfigureClone(Git git, String user, String gitUserName, String gitUserMail) throws IOException, CoreException {
        StoredConfig config = git.getRepository().getConfig();
        if (gitUserName != null) {
            config.setString("user", null, "name", gitUserName);
        }
        if (gitUserMail != null) {
            config.setString("user", null, "email", gitUserMail);
        }
        config.setBoolean("core", null, "filemode", false);
        config.save();
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String pathString) throws IOException, JSONException, ServletException, URISyntaxException, CoreException {
        Path path = pathString == null ? Path.EMPTY : new Path(pathString);
        URI baseLocation = GitCloneHandlerV1.getURI((HttpServletRequest)request);
        String user = request.getRemoteUser();
        if ("workspace".equals(path.segment(0)) && path.segmentCount() == 2) {
            WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(1));
            if (workspace != null) {
                JSONObject result = new JSONObject();
                JSONArray children = new JSONArray();
                for (String projectName : workspace.getProjectNames()) {
                    ProjectInfo project = OrionConfiguration.getMetaStore().readProject(workspace.getUniqueId(), projectName);
                    if (!this.isAccessAllowed(user, project)) continue;
                    IPath projectPath = GitUtils.pathFromProject(workspace, project);
                    Map<IPath, File> gitDirs = GitUtils.getGitDirs(projectPath, GitUtils.Traverse.GO_DOWN);
                    for (Map.Entry<IPath, File> entry : gitDirs.entrySet()) {
                        children.put((Object)new Clone().toJSON(entry, baseLocation));
                    }
                }
                result.put("Type", (Object)"Clone");
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        if ("file".equals(path.segment(0)) && path.segmentCount() > 1) {
            ProjectInfo webProject = GitUtils.projectFromPath((IPath)path);
            IPath projectRelativePath = path.removeFirstSegments(3);
            if (webProject != null && this.isAccessAllowed(user, webProject) && webProject.getProjectStore().getFileStore(projectRelativePath).fetchInfo().exists()) {
                Map<IPath, File> gitDirs = GitUtils.getGitDirs((IPath)path, GitUtils.Traverse.GO_DOWN);
                JSONObject result = new JSONObject();
                JSONArray children = new JSONArray();
                for (Map.Entry<IPath, File> entry : gitDirs.entrySet()) {
                    children.put((Object)new Clone().toJSON(entry, baseLocation));
                }
                result.put("Type", (Object)"Clone");
                result.put("Children", (Object)children);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        String msg = NLS.bind((String)"Invalid clone request: {0}", (Object)path);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, String pathString) throws GitAPIException, CoreException, IOException, JSONException, ServletException {
        Path path;
        Path path2 = path = pathString == null ? Path.EMPTY : new Path(pathString);
        if (path.segment(0).equals("file") && path.segmentCount() > 1) {
            ProjectInfo webProject = GitUtils.projectFromPath((IPath)path);
            if (this.isAccessAllowed(request.getRemoteUser(), webProject)) {
                Map<IPath, File> gitDirs = GitUtils.getGitDirs((IPath)path, GitUtils.Traverse.CURRENT);
                if (gitDirs.isEmpty()) {
                    String msg = NLS.bind((String)"Request path is not a git repository: {0}", (Object)path);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                File gitDir = gitDirs.values().iterator().next();
                JSONObject toCheckout = OrionServlet.readJSONRequest((HttpServletRequest)request);
                JSONArray paths = toCheckout.optJSONArray("Path");
                String branch = toCheckout.optString("Branch", null);
                String tag = toCheckout.optString("Tag", null);
                boolean removeUntracked = toCheckout.optBoolean("RemoveUntracked", false);
                if ((paths == null || paths.length() == 0) && branch == null && tag == null) {
                    String msg = NLS.bind((String)"Either '{0}' or '{1}' or '{2}' should be provided, got: {3}", (Object[])new Object[]{"Path", "Branch", "Tag", toCheckout});
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                Git git = new Git(FileRepositoryBuilder.create((File)gitDir));
                if (paths != null) {
                    HashSet<String> toRemove = new HashSet<String>();
                    CheckoutCommand checkout = git.checkout();
                    int i = 0;
                    while (i < paths.length()) {
                        String p = paths.getString(i);
                        if (removeUntracked && !this.isInIndex(git.getRepository(), p)) {
                            toRemove.add(p);
                        }
                        checkout.addPath(p);
                        ++i;
                    }
                    checkout.call();
                    for (String p : toRemove) {
                        File f = new File(git.getRepository().getWorkTree(), p);
                        f.delete();
                    }
                    return true;
                }
                if (tag != null && branch != null) {
                    CheckoutCommand co = git.checkout();
                    try {
                        co.setName(branch).setStartPoint(tag).setCreateBranch(true).call();
                        return true;
                    }
                    catch (RefNotFoundException e) {
                        String msg = NLS.bind((String)"Tag not found: {0}", (Object)tag);
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, (Throwable)e));
                    }
                    catch (GitAPIException e) {
                        if (CheckoutResult.Status.CONFLICTS.equals((Object)co.getResult().getStatus())) {
                            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 409, "Checkout aborted.", (Throwable)e));
                        }
                    }
                } else if (branch != null) {
                    if (!this.isLocalBranch(git, branch)) {
                        String msg = NLS.bind((String)"{0} is not a branch.", (Object)branch);
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
                    }
                    CheckoutCommand co = git.checkout();
                    try {
                        co.setName("refs/heads/" + branch).call();
                        return true;
                    }
                    catch (CheckoutConflictException e) {
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 409, "Checkout aborted.", (Throwable)e));
                    }
                    catch (RefNotFoundException e) {
                        String msg = NLS.bind((String)"Branch name not found: {0}", (Object)branch);
                        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, (Throwable)e));
                    }
                }
            } else {
                String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
            }
        }
        String msg = NLS.bind((String)"Invalid checkout request {0}", (Object)pathString);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    private boolean isLocalBranch(Git git, String branch) throws GitAPIException {
        List branches = git.branchList().call();
        for (Ref ref : branches) {
            if (!Repository.shortenRefName((String)ref.getName()).equals(branch)) continue;
            return true;
        }
        return false;
    }

    private boolean isInIndex(Repository db, String path) throws IOException {
        DirCache dc = DirCache.read((File)db.getIndexFile(), (FS)db.getFS());
        return dc.getEntry(path) != null;
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String pathString) throws GitAPIException, CoreException, IOException, ServletException {
        Path path;
        Path path2 = path = pathString == null ? Path.EMPTY : new Path(pathString);
        if (path.segment(0).equals("file") && path.segmentCount() > 2) {
            ProjectInfo webProject = GitUtils.projectFromPath((IPath)path);
            if (webProject != null && this.isAccessAllowed(request.getRemoteUser(), webProject)) {
                File gitDir = GitUtils.getGitDirs((IPath)path, GitUtils.Traverse.CURRENT).values().iterator().next();
                Repository repo = FileRepositoryBuilder.create((File)gitDir);
                repo.close();
                FileUtils.delete((File)repo.getWorkTree(), (int)3);
                if (path.segmentCount() == 3) {
                    return this.statusHandler.handleRequest(request, response, (Object)GitCloneHandlerV1.removeProject(request.getRemoteUser(), webProject));
                }
                return true;
            }
            String msg = NLS.bind((String)"Nothing found for the given ID: {0}", (Object)path);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        String msg = NLS.bind((String)"Invalid delete request {0}", (Object)pathString);
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAccessAllowed(String userName, ProjectInfo webProject) {
        try {
            String workspaceId;
            WorkspaceInfo workspace;
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userName);
            Iterator iterator = user.getWorkspaceIds().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                workspaceId = (String)iterator.next();
            } while (!(workspace = OrionConfiguration.getMetaStore().readWorkspace(workspaceId)).getProjectNames().contains(webProject.getFullName()));
            return true;
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
        return false;
    }

    public static ServerStatus removeProject(String userId, ProjectInfo project) {
        try {
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userId);
            for (String workspaceId : user.getWorkspaceIds()) {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(workspaceId);
                for (String projectName : workspace.getProjectNames()) {
                    if (!projectName.equals(project.getFullName())) continue;
                    try {
                        WorkspaceResourceHandler.removeProject((String)userId, (WorkspaceInfo)workspace, (ProjectInfo)project);
                    }
                    catch (CoreException e) {
                        String msg = NLS.bind((String)"Failed to remove project: {0}", (Object)project.getFullName());
                        return new ServerStatus(4, 500, msg, (Throwable)e);
                    }
                    return new ServerStatus(0, 200, null, null);
                }
            }
        }
        catch (Exception exception) {}
        return new ServerStatus(0, 200, null, null);
    }

    private boolean validateCloneName(String name, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (name == null) {
            return true;
        }
        if (name.trim().length() == 0) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Repository name cannot be empty", null));
            return false;
        }
        if (name.contains("/")) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Invalid repository name: {0}", (Object)name), null));
            return false;
        }
        return true;
    }

    private boolean validateCloneUrl(String url, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (url == null || url.trim().length() == 0) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Clone URL cannot be empty", null));
            return false;
        }
        try {
            URIish uri = new URIish(url);
            if (GitUtils.isForbiddenGitUri(uri)) {
                this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Clone URL {0} does not appear to be a git repository", (Object)uri), null));
                return false;
            }
        }
        catch (URISyntaxException e) {
            this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, NLS.bind((String)"Invalid clone URL: {0}", (Object)url), (Throwable)e));
            return false;
        }
        return true;
    }

    private boolean pull(HttpServletRequest request, HttpServletResponse response, GitCredentialsProvider cp, String path, boolean force) throws URISyntaxException, JSONException, IOException, ServletException {
        Path p = new Path(path);
        PullJob job = new PullJob(TaskJobHandler.getUserId((HttpServletRequest)request), (CredentialsProvider)cp, p, force);
        return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, this.statusHandler);
    }
}

