/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.project;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.project.Project;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectHandlerV1
extends ServletResourceHandler<Project> {
    final ServletResourceHandler<IStatus> statusHandler;

    public ProjectHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, Project project) throws ServletException {
        switch (ProjectHandlerV1.getMethod(request)) {
            case GET: {
                this.handleGet(request, response, project);
                return true;
            }
        }
        return false;
    }

    private void handleGet(HttpServletRequest request, HttpServletResponse response, Project project) throws ServletException {
        if (project == null || !project.exists()) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 404, "Could not find project", null));
            return;
        }
        try {
            JSONObject projectJson = project.toJson();
            URI uri = ProjectHandlerV1.getURI(request);
            String pathInfo = request.getPathInfo();
            Path path = new Path(pathInfo);
            projectJson.put("Location", (Object)uri);
            projectJson.put("ContentLocation", (Object)(String.valueOf(URIUtil.append((URI)URIUtil.append((URI)uri.resolve("/file"), (String)path.segment(0)), (String)path.segment(1)).toString()) + "/?depth=1"));
            OrionServlet.writeJSONResponse(request, response, projectJson);
        }
        catch (JSONException e) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, "Internal error while creating response", (Throwable)e));
        }
        catch (IOException e) {
            this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 500, "Internal error while creating response", (Throwable)e));
        }
    }
}

