/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.xfer.ContentRange;
import org.eclipse.orion.internal.server.servlets.xfer.TransferServlet;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientImport {
    private static final String FILE_DATA = "xfer.data";
    private static final String FILE_INDEX = "xfer.properties";
    private static final String KEY_FILE_NAME = "FileName";
    private static final String KEY_LENGTH = "Length";
    private static final String KEY_OPTIONS = "Options";
    private static final String KEY_PATH = "Path";
    private static final String KEY_TRANSFERRED = "Transferred";
    private static final String KEY_SOURCE_URL = "SourceURL";
    private final String id;
    private Properties props = new Properties();
    private final ServletResourceHandler<IStatus> statusHandler;

    ClientImport(String id, ServletResourceHandler<IStatus> servletResourceHandler) throws IOException {
        this.id = id;
        this.statusHandler = servletResourceHandler;
        this.restore();
    }

    private boolean completeMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        IPath destPath = new Path(this.getPath()).append(this.getFileName());
        try {
            IFileStore source = EFS.getStore((URI)new File(this.getStorageDirectory(), FILE_DATA).toURI());
            IFileStore destination = NewFileServlet.getFileStore(req, destPath);
            source.move(destination, 2, null);
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return false;
        }
        return true;
    }

    private void completeTransfer(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List<String> options = this.getOptions();
        boolean success = !options.contains("raw") ? this.completeUnzip(req, resp) : this.completeMove(req, resp);
        if (success) {
            resp.setHeader("Location", String.valueOf(req.getContextPath()) + "/file" + this.getPath());
            resp.setStatus(201);
            resp.setContentType("text/html;charset=UTF-8");
        }
    }

    private static boolean hasExcludedParent(IFileStore destination, IFileStore destinationRoot, List<String> excludedFiles) {
        if (destination.equals(destinationRoot)) {
            return false;
        }
        if (excludedFiles.contains(destination.getName())) {
            return true;
        }
        return ClientImport.hasExcludedParent(destination.getParent(), destinationRoot, excludedFiles);
    }

    private boolean completeUnzip(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        Path destPath = new Path(this.getPath());
        boolean force = false;
        ArrayList<String> filesFailed = new ArrayList<String>();
        if (req.getParameter("force") != null) {
            force = req.getParameter("force").equals("true");
        }
        ArrayList<String> excludedFiles = new ArrayList();
        if (req.getParameter("exclude") != null) {
            excludedFiles = Arrays.asList(req.getParameter("exclude").split(","));
        }
        try {
            ZipFile source = new ZipFile(new File(this.getStorageDirectory(), FILE_DATA));
            IFileStore destinationRoot = NewFileServlet.getFileStore(req, (IPath)destPath);
            Enumeration<? extends ZipEntry> entries = source.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                IFileStore destination = destinationRoot.getChild(entry.getName());
                if (!destinationRoot.isParentOf(destination) || ClientImport.hasExcludedParent(destination, destinationRoot, excludedFiles)) continue;
                if (entry.isDirectory()) {
                    destination.mkdir(0, null);
                    continue;
                }
                if (!force && destination.fetchInfo().exists()) {
                    filesFailed.add(entry.getName());
                    continue;
                }
                destination.getParent().mkdir(0, null);
                FilterInputStream maxBytesReadInputStream = new FilterInputStream(source.getInputStream(entry)){
                    private static final int maxBytes = 0x6400000;
                    private int totalBytes;

                    private void addByteCount(int count) throws IOException {
                        this.totalBytes += count;
                        if (this.totalBytes > 0x6400000) {
                            throw new IOException("Zip file entry too large");
                        }
                    }

                    public int read() throws IOException {
                        int c = super.read();
                        if (c != -1) {
                            this.addByteCount(1);
                        }
                        return c;
                    }

                    public int read(byte[] b, int off, int len) throws IOException {
                        int read = super.read(b, off, len);
                        if (read != -1) {
                            this.addByteCount(read);
                        }
                        return read;
                    }
                };
                boolean fileWritten = false;
                try {
                    IOUtilities.pipe((InputStream)maxBytesReadInputStream, (OutputStream)destination.openOutputStream(0, null), (boolean)false, (boolean)true);
                    fileWritten = true;
                }
                catch (Throwable throwable) {
                    if (!fileWritten) {
                        try {
                            destination.delete(0, null);
                        }
                        catch (CoreException coreException) {}
                    }
                    throw throwable;
                }
                if (fileWritten) continue;
                try {
                    destination.delete(0, null);
                }
                catch (CoreException coreException) {}
            }
            source.close();
            if (!filesFailed.isEmpty()) {
                String failedFilesList = "";
                for (String file : filesFailed) {
                    if (failedFilesList.length() > 0) {
                        failedFilesList = String.valueOf(failedFilesList) + ", ";
                    }
                    failedFilesList = String.valueOf(failedFilesList) + file;
                }
                String msg = NLS.bind((String)"Failed to transfer all files to {0}, the following files could not be overwritten {1}", (Object)destPath.toString(), (Object)failedFilesList);
                JSONObject jsonData = new JSONObject();
                jsonData.put("ExistingFiles", filesFailed);
                this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, jsonData, null));
                return false;
            }
        }
        catch (ZipException e) {
            String msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, (Throwable)e));
            return false;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return false;
        }
        return true;
    }

    void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.save();
        if (this.getSourceURL() != null) {
            this.doImportFromURL(req, resp);
            return;
        }
        if (req.getHeader("X-Xfer-Content-Length") == null) {
            this.doPut(req, resp);
            return;
        }
        resp.setStatus(200);
        this.setResponseLocationHeader(req, resp);
    }

    private void doImportFromURL(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        URL source = this.getSourceURL();
        IOUtilities.pipe((InputStream)source.openStream(), (OutputStream)new FileOutputStream(new File(this.getStorageDirectory(), FILE_DATA), true), (boolean)true, (boolean)true);
        this.completeTransfer(req, resp);
    }

    private void setResponseLocationHeader(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        URI responseURI;
        URI requestURI = ServletResourceHandler.getURI(req);
        String responsePath = "/" + new Path(requestURI.getPath()).segment(0) + "/import/" + this.id;
        try {
            responseURI = new URI(requestURI.getScheme(), requestURI.getAuthority(), responsePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        resp.setHeader("Location", ServletResourceHandler.resovleOrionURI(req, responseURI).toString());
    }

    void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ContentRange range;
        int transferred = this.getTransferred();
        int length = this.getLength();
        int headerLength = Integer.valueOf(req.getHeader("Content-Length"));
        String rangeString = req.getHeader("Content-Range");
        if (rangeString == null) {
            rangeString = "bytes 0-" + (length - 1) + '/' + length;
        }
        if (length != (range = ContentRange.parse(rangeString)).getLength()) {
            this.fail(req, resp, "Chunk specifies an incorrect document length");
            return;
        }
        if (range.getStartByte() > transferred) {
            this.fail(req, resp, "Chunk missing; Expected start byte: " + transferred);
            return;
        }
        if (range.getEndByte() < range.getStartByte()) {
            this.fail(req, resp, "Invalid range: " + rangeString);
            return;
        }
        int chunkSize = 1 + range.getEndByte() - range.getStartByte();
        if (chunkSize != headerLength) {
            this.fail(req, resp, "Content-Range doesn't agree with Content-Length");
            return;
        }
        byte[] chunk = this.readChunk(req, chunkSize);
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.getStorageDirectory(), FILE_DATA), true);
            FileChannel channel = fout.getChannel();
            channel.position(range.getStartByte());
            channel.write(ByteBuffer.wrap(chunk));
            channel.close();
        }
        catch (Throwable throwable) {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException iOException) {}
        transferred = range.getEndByte() + 1;
        this.setTransferred(transferred);
        this.save();
        if (transferred >= length) {
            this.completeTransfer(req, resp);
            return;
        }
        resp.setStatus(308);
        resp.setHeader("Range", "bytes 0-" + range.getEndByte());
        this.setResponseLocationHeader(req, resp);
    }

    private byte[] readChunk(HttpServletRequest req, int chunkSize) throws IOException {
        ServletInputStream requestStream = req.getInputStream();
        String contentType = req.getHeader("Content-Type");
        if (contentType != null && contentType.startsWith("multipart")) {
            return this.readMultiPartChunk(requestStream, contentType);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(chunkSize);
        IOUtilities.pipe((InputStream)requestStream, (OutputStream)outputStream, (boolean)false, (boolean)false);
        return outputStream.toByteArray();
    }

    private byte[] readMultiPartChunk(ServletInputStream requestStream, String contentType) throws IOException {
        int read;
        int boundaryOff = contentType.indexOf("boundary=");
        String boundary = contentType.substring(boundaryOff + 9);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)requestStream, "ISO-8859-1"));
        StringBuffer out = new StringBuffer();
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            line = reader.readLine();
        }
        char[] buf = new char[1000];
        while ((read = reader.read(buf)) > 0) {
            out.append(buf, 0, read);
        }
        out.setLength(out.length() - (boundary.length() + 8));
        return out.toString().getBytes("ISO-8859-1");
    }

    private void fail(HttpServletRequest req, HttpServletResponse resp, String msg) throws ServletException {
        this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, null));
    }

    private String getFileName() {
        return this.props.getProperty(KEY_FILE_NAME, "");
    }

    private int getLength() {
        return Integer.valueOf(this.props.getProperty(KEY_LENGTH, "0"));
    }

    private List<String> getOptions() {
        return TransferServlet.getOptions(this.props.getProperty(KEY_OPTIONS, ""));
    }

    private String getPath() {
        return this.props.getProperty(KEY_PATH, "");
    }

    private URL getSourceURL() {
        String urlString = this.props.getProperty(KEY_SOURCE_URL, null);
        try {
            return urlString == null ? null : new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private File getStorageDirectory() {
        return FrameworkUtil.getBundle(ClientImport.class).getDataFile("xfer/" + this.id);
    }

    private Integer getTransferred() {
        return Integer.valueOf(this.props.getProperty(KEY_TRANSFERRED, "0"));
    }

    void restore() throws IOException {
        try {
            File dir = this.getStorageDirectory();
            File index = new File(dir, FILE_INDEX);
            this.props.load(new FileInputStream(index));
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    void save() throws IOException {
        File dir = this.getStorageDirectory();
        dir.mkdirs();
        File index = new File(dir, FILE_INDEX);
        this.props.store(new FileOutputStream(index), null);
    }

    public void setFileName(String name) {
        this.props.put(KEY_FILE_NAME, name == null ? "" : name);
    }

    public void setLength(long length) {
        this.props.put(KEY_LENGTH, Long.toString(length));
    }

    public void setOptions(String options) {
        this.props.put(KEY_OPTIONS, options == null ? "" : options);
    }

    public void setPath(IPath path) {
        this.props.put(KEY_PATH, path.toString());
    }

    private void setTransferred(int transferred) {
        this.props.put(KEY_TRANSFERRED, Integer.toString(transferred));
    }

    public void setSourceURL(String urlString) throws MalformedURLException {
        if (new URL(urlString).getProtocol() == null) {
            throw new MalformedURLException(NLS.bind((String)"Expected an absolute URI: {0}", (Object)urlString));
        }
        this.props.put(KEY_SOURCE_URL, urlString);
    }
}

