/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.useradmin.simple;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.internal.server.core.metastore.SimpleUserPasswordUtil;
import org.eclipse.orion.internal.server.useradmin.simple.SimpleUserProfileProperties;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleUserProfileNode
implements IOrionUserProfileNode {
    private JSONObject userJSONObject = null;
    private File rootLocation = null;
    private String userId = null;
    private static final String USER = "user";
    private SimpleUserProfileProperties profileProperties = null;
    public static final String USER_PROPERTIES = "profileProperties";

    public SimpleUserProfileNode(File rootLocation, String userId) {
        this.rootLocation = rootLocation;
        this.userId = userId;
        this.init(userId);
    }

    private void init(String userId) {
        try {
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder((File)this.rootLocation, (String)userId);
            if (!SimpleMetaStoreUtil.isMetaFile((File)userMetaFolder, (String)USER)) {
                return;
            }
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile((File)userMetaFolder, (String)USER);
            if (jsonObject == null) {
                throw new RuntimeException("SimpleUserProfileNode.init: user.json is blank for user " + userId);
            }
            this.userJSONObject = jsonObject;
            if (this.userJSONObject.has(USER_PROPERTIES)) {
                JSONObject profilePropertiesJSON = jsonObject.getJSONObject(USER_PROPERTIES);
                this.profileProperties = new SimpleUserProfileProperties(profilePropertiesJSON);
            } else {
                JSONObject profilePropertiesJSON = new JSONObject();
                this.profileProperties = new SimpleUserProfileProperties(profilePropertiesJSON);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    public SimpleUserProfileNode(String userName, String partId) {
        if (!"general".equals(partId)) {
            throw new RuntimeException("SimpleUserProfileNode: unknown partId " + partId + " for user " + userName);
        }
        this.init(userName);
    }

    public void put(String key, String value, boolean encrypt) throws CoreException {
        try {
            if (key.equals("name")) {
                this.userJSONObject.put("FullName", (Object)value);
            } else {
                if (key.equals("uid")) {
                    throw new RuntimeException("SimpleUserProfileNode.put: cannot reset the user id for " + this.userJSONObject.getString("UserName"));
                }
                if (key.equals("login")) {
                    String userName;
                    if (this.userJSONObject.has("UserName") && !(userName = this.userJSONObject.getString("UserName")).equals(value)) {
                        this.rename(userName, value);
                    }
                } else {
                    String newValue = value;
                    if (encrypt) {
                        newValue = SimpleUserPasswordUtil.encryptPassword((String)value);
                    }
                    this.userJSONObject.put(key, (Object)newValue);
                }
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void rename(String oldUserName, String newUserName) {
        try {
            this.flush();
            UserInfo userInfo = OrionConfiguration.getMetaStore().readUser(oldUserName);
            userInfo.setUserName(newUserName);
            OrionConfiguration.getMetaStore().updateUser(userInfo);
            this.init(newUserName);
            this.userId = newUserName;
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
    }

    public String get(String key, String def) throws CoreException {
        try {
            if (key.equals("name")) {
                return this.userJSONObject.getString("FullName");
            }
            if (key.equals("uid")) {
                return this.userJSONObject.getString("UniqueId");
            }
            if (key.equals("login")) {
                return this.userJSONObject.getString("UserName");
            }
            if (this.userJSONObject.has(key)) {
                return this.userJSONObject.getString(key);
            }
            return def;
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
            return null;
        }
    }

    public void remove(String key) {
        this.userJSONObject.remove(key);
    }

    public String[] keys() {
        throw new UnsupportedOperationException("Keys not supported by SimpleUserProfileNode");
    }

    public IOrionUserProfileNode getUserProfileNode(String pathName) {
        if (this.userJSONObject == null) {
            return null;
        }
        if (pathName.equals("general")) {
            return this;
        }
        if (pathName.equals(USER_PROPERTIES)) {
            return this.profileProperties;
        }
        throw new UnsupportedOperationException("SimpleUserProfileNode.getUserProfileNode: path not supported: " + pathName);
    }

    public boolean userProfileNodeExists(String pathName) {
        if (this.userJSONObject == null) {
            return false;
        }
        if (pathName.equals("general")) {
            return true;
        }
        return pathName.equals(USER_PROPERTIES);
    }

    public void removeUserProfileNode() {
        throw new UnsupportedOperationException("RemoveUserProfileNode not supported by SimpleUserProfileNode");
    }

    public String[] childrenNames() {
        return new String[0];
    }

    public void flush() throws CoreException {
        try {
            File userMetaFolder;
            String[] keys = this.profileProperties.keys();
            if (keys.length > 0) {
                JSONObject properties = new JSONObject();
                int i = 0;
                while (i < keys.length) {
                    String key = keys[i];
                    String value = this.profileProperties.get(key, "");
                    properties.put(key, (Object)value);
                    ++i;
                }
                this.userJSONObject.put(USER_PROPERTIES, (Object)properties);
            }
            if (!SimpleMetaStoreUtil.updateMetaFile((File)(userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder((File)this.rootLocation, (String)this.userId)), (String)USER, (JSONObject)this.userJSONObject)) {
                throw new RuntimeException("SimpleUserProfileNode.flush: could not update user: " + this.userId);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }
}

