/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.docker.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.docker.server.DockerContainer;
import org.eclipse.orion.server.docker.server.DockerContainers;
import org.eclipse.orion.server.docker.server.DockerImage;
import org.eclipse.orion.server.docker.server.DockerImages;
import org.eclipse.orion.server.docker.server.DockerResponse;
import org.eclipse.orion.server.docker.server.DockerServer;
import org.eclipse.orion.server.docker.server.DockerVersion;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHandler
extends ServletResourceHandler<String> {
    private DockerServer dockerServer = null;
    protected ServletResourceHandler<IStatus> statusHandler;

    public DockerHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
        this.initDockerServer();
    }

    private DockerServer getDockerServer() {
        return this.dockerServer;
    }

    private List<String> getDockerVolumes(String user) {
        try {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
            ArrayList<String> volumes = new ArrayList<String>();
            IMetaStore metaStore = OrionConfiguration.getMetaStore();
            UserInfo userInfo = metaStore.readUser(user);
            List workspaceIds = userInfo.getWorkspaceIds();
            if (workspaceIds.isEmpty()) {
                return volumes;
            }
            String workspaceId = (String)workspaceIds.get(0);
            WorkspaceInfo workspaceInfo = metaStore.readWorkspace(workspaceId);
            List projectNames = workspaceInfo.getProjectNames();
            for (String projectName : projectNames) {
                ProjectInfo projectInfo = metaStore.readProject(workspaceId, projectName);
                URI contentLocation = projectInfo.getContentLocation();
                if (contentLocation.getScheme().equals("file")) {
                    String localVolume = EFS.getStore((URI)contentLocation).toLocalFile(0, null).getAbsolutePath();
                    if (localVolume.indexOf("/OrionContent") != -1) {
                        String orionVolume = localVolume.substring(localVolume.indexOf("/OrionContent"));
                        String volume = String.valueOf(localVolume) + ":" + orionVolume + ":rw";
                        volumes.add(volume);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Cannot handle mapped project " + contentLocation.toString() + " for user " + user);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Cannot handle ftp project " + contentLocation.toString() + " for user " + user);
            }
            return volumes;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean handleConnectDockerContainerRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String originURL;
            DockerResponse dockerResponse;
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
            String user = request.getRemoteUser();
            DockerServer dockerServer = this.getDockerServer();
            if (dockerServer.isAttachedDockerContainer(user)) {
                DockerResponse deleteResponse;
                dockerServer.detachDockerContainer(user);
                DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
                if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.OK) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
                }
                dockerContainer = dockerServer.stopDockerContainer(user);
                if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.STOPPED) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopped Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
                if ((deleteResponse = dockerServer.deleteDockerContainer(user)).getStatusCode() != DockerResponse.StatusCode.DELETED) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Deleted Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
            }
            List<String> volumes = this.getDockerVolumes(user);
            DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
            if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.OK) {
                dockerContainer = dockerServer.createDockerContainer("orion.base", user, "orionuser", volumes);
                if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.CREATED) {
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
            }
            if ((dockerContainer = dockerServer.startDockerContainer(user, volumes)).getStatusCode() == DockerResponse.StatusCode.STARTED) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Started Docker Container " + dockerContainer.getIdShort() + " for user " + user);
                }
            } else if (dockerContainer.getStatusCode() == DockerResponse.StatusCode.RUNNING) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Docker Container " + dockerContainer.getIdShort() + " for user " + user + " is already running");
                }
            } else {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
            }
            if ((dockerResponse = dockerServer.attachDockerContainer(user, originURL = request.getRequestURL().toString())).getStatusCode() != DockerResponse.StatusCode.ATTACHED) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Attach Docker Container " + dockerContainer.getIdShort() + " for user " + user + " successful");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("attachWsURI", (Object)dockerResponse.getStatusMessage());
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
            return true;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    private boolean handleDisconnectDockerContainerRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        DockerResponse deleteResponse;
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
        String user = request.getRemoteUser();
        DockerServer dockerServer = this.getDockerServer();
        DockerContainer dockerContainer = dockerServer.getDockerContainer(user);
        if (dockerContainer.getStatusCode() != DockerResponse.StatusCode.OK) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
        }
        if (dockerServer.isAttachedDockerContainer(user)) {
            dockerServer.detachDockerContainer(user);
        }
        if ((dockerContainer = dockerServer.stopDockerContainer(user)).getStatusCode() != DockerResponse.StatusCode.STOPPED) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped Docker Container " + dockerContainer.getIdShort() + " for user " + user);
        }
        if ((deleteResponse = dockerServer.deleteDockerContainer(user)).getStatusCode() != DockerResponse.StatusCode.DELETED) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, dockerContainer.getStatusMessage(), null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted Docker Container " + dockerContainer.getIdShort() + " for user " + user);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerContainerRequest(HttpServletRequest request, HttpServletResponse response, String string) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerContainer dockerContainer = dockerServer.getDockerContainer(string);
            switch (dockerContainer.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerContainer.getStatusMessage());
                    return false;
                }
                case NO_SUCH_IMAGE: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerContainer.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerContainer.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Id", (Object)dockerContainer.getIdShort());
                    jsonObject.put("Image", (Object)dockerContainer.getImage());
                    jsonObject.put("Command", (Object)dockerContainer.getCommand());
                    jsonObject.put("Created", (Object)dockerContainer.getCreated());
                    jsonObject.put("Status", (Object)dockerContainer.getStatus());
                    jsonObject.put("Ports", (Object)dockerContainer.getPorts());
                    jsonObject.put("Name", (Object)dockerContainer.getName());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerContainersRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerContainers dockerContainers = dockerServer.getDockerContainers();
            switch (dockerContainers.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerContainers.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Containers", (Object)dockerContainers.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONArray jsonArray = new JSONArray();
                    Iterator<DockerContainer> iterator = dockerContainers.getContainers().iterator();
                    while (true) {
                        JSONObject jsonObject;
                        if (!iterator.hasNext()) {
                            jsonObject = new JSONObject();
                            jsonObject.put("Containers", (Object)jsonArray);
                            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                            return true;
                        }
                        DockerContainer dockerContainer = iterator.next();
                        jsonObject = new JSONObject();
                        jsonObject.put("Id", (Object)dockerContainer.getIdShort());
                        jsonObject.put("Image", (Object)dockerContainer.getImage());
                        jsonObject.put("Command", (Object)dockerContainer.getCommand());
                        jsonObject.put("Created", (Object)dockerContainer.getCreated());
                        jsonObject.put("Status", (Object)dockerContainer.getStatus());
                        jsonObject.put("Ports", (Object)dockerContainer.getPorts());
                        jsonObject.put("Name", (Object)dockerContainer.getName());
                        jsonArray.put((Object)jsonObject);
                    }
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerImageRequest(HttpServletRequest request, HttpServletResponse response, String string) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerImage dockerImage = dockerServer.getDockerImage(string);
            switch (dockerImage.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerImage.getStatusMessage());
                    return false;
                }
                case NO_SUCH_IMAGE: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerImage.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Image", (Object)dockerImage.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Repository", (Object)dockerImage.getRepository());
                    jsonObject.put("Tag", (Object)dockerImage.getTag());
                    jsonObject.put("Id", (Object)dockerImage.getId());
                    jsonObject.put("Created", (Object)dockerImage.getCreated());
                    jsonObject.put("Size", dockerImage.getSize());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerImagesRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerImages dockerImages = dockerServer.getDockerImages();
            switch (dockerImages.getStatusCode()) {
                case SERVER_ERROR: {
                    response.sendError(500, dockerImages.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Images", (Object)dockerImages.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONArray jsonArray = new JSONArray();
                    Iterator<DockerImage> iterator = dockerImages.getImages().iterator();
                    while (true) {
                        JSONObject jsonObject;
                        if (!iterator.hasNext()) {
                            jsonObject = new JSONObject();
                            jsonObject.put("Images", (Object)jsonArray);
                            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                            return true;
                        }
                        DockerImage dockerImage = iterator.next();
                        jsonObject = new JSONObject();
                        jsonObject.put("Repository", (Object)dockerImage.getRepository());
                        jsonObject.put("Tag", (Object)dockerImage.getTag());
                        jsonObject.put("Id", (Object)dockerImage.getId());
                        jsonObject.put("Created", (Object)dockerImage.getCreated());
                        jsonObject.put("Size", dockerImage.getSize());
                        jsonArray.put((Object)jsonObject);
                    }
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleDockerVersionRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            DockerServer dockerServer = this.getDockerServer();
            DockerVersion dockerVersion = dockerServer.getDockerVersion();
            switch (dockerVersion.getStatusCode()) {
                case BAD_PARAMETER: {
                    response.sendError(400, dockerVersion.getStatusMessage());
                    return false;
                }
                case SERVER_ERROR: {
                    response.sendError(500, dockerVersion.getStatusMessage());
                    return false;
                }
                case CONNECTION_REFUSED: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Version", (Object)dockerVersion.getStatusMessage());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
                case OK: {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Version", (Object)dockerVersion.getVersion());
                    OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)jsonObject);
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "IOException with request", (Throwable)e));
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "JSONException with request", (Throwable)e));
        }
    }

    private boolean handleGetRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String[] pathSplit = path.split("\\/", 2);
        String dockerRequest = pathSplit[0];
        if (dockerRequest.equals("version")) {
            return this.handleDockerVersionRequest(request, response);
        }
        if (dockerRequest.equals("images")) {
            return this.handleDockerImagesRequest(request, response);
        }
        if (dockerRequest.equals("image")) {
            return this.handleDockerImageRequest(request, response, pathSplit[1]);
        }
        if (dockerRequest.equals("containers")) {
            return this.handleDockerContainersRequest(request, response);
        }
        if (dockerRequest.equals("container")) {
            return this.handleDockerContainerRequest(request, response, pathSplit[1]);
        }
        return false;
    }

    private boolean handlePostRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String[] pathSplit = path.split("\\/", 2);
        String dockerRequest = pathSplit[0];
        if (dockerRequest.equals("connect")) {
            return this.handleConnectDockerContainerRequest(request, response);
        }
        if (dockerRequest.equals("disconnect")) {
            return this.handleDisconnectDockerContainerRequest(request, response);
        }
        return false;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        if (this.dockerServer == null) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "A Docker server required for terminal support is not enabled on this Orion server.", null));
        }
        switch (DockerHandler.getMethod((HttpServletRequest)request)) {
            case GET: {
                return this.handleGetRequest(request, response, path);
            }
            case POST: {
                return this.handlePostRequest(request, response, path);
            }
        }
        return false;
    }

    private void initDockerServer() {
        try {
            URI dockerLocationURI;
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
            String dockerLocation = PreferenceHelper.getString((String)"orion.core.docker.uri", (String)"none").toLowerCase();
            if ("none".equals(dockerLocation)) {
                this.dockerServer = null;
                logger.debug("No Docker Server specified by \"orion.core.docker.uri\" in orion.conf");
                return;
            }
            URI dockerProxyURI = dockerLocationURI = new URI(dockerLocation);
            String dockerProxy = PreferenceHelper.getString((String)"orion.core.docker.proxy.uri", (String)"none").toLowerCase();
            if (!"none".equals(dockerProxy)) {
                dockerProxyURI = new URI(dockerProxy);
                logger.debug("Docker Proxy Server " + dockerProxy + " is enabled");
            }
            this.dockerServer = new DockerServer(dockerLocationURI, dockerProxyURI);
            DockerVersion dockerVersion = this.dockerServer.getDockerVersion();
            if (logger.isDebugEnabled()) {
                if (dockerVersion.getStatusCode() != DockerResponse.StatusCode.OK) {
                    logger.error("Cound not connect to docker server " + dockerLocation + ": " + dockerVersion.getStatusMessage());
                } else {
                    logger.debug("Docker Server " + dockerLocation + " is running version " + dockerVersion.getVersion());
                }
            }
        }
        catch (URISyntaxException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.dockerServer = null;
        }
    }
}

