/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractRevertableCFCommand;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindServicesCommand
extends AbstractRevertableCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;

    public BindServicesCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Bind new services to application {1} (guid: {2})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            JSONObject appJSON = ManifestUtils.getApplication(this.application.getManifest());
            if (appJSON.has("services")) {
                Object serviceName;
                String spaceGuid;
                URI servicesURI = targetURI.resolve("/v2/services");
                GetMethod getServicesMethod = new GetMethod(servicesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getServicesMethod, this.target);
                getServicesMethod.setQueryString("inline-relations-depth=1");
                ServerStatus jobStatus = HttpUtil.executeMethod((HttpMethod)getServicesMethod);
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return this.revert(status);
                }
                JSONObject resp = jobStatus.getJsonData();
                JSONArray servicesJSON = resp.getJSONArray("resources");
                JSONObject version2 = appJSON.optJSONObject("services");
                JSONArray version6 = appJSON.optJSONArray("services");
                if (version2 != null) {
                    spaceGuid = this.target.getSpace().getGuid();
                    URI serviceInstancesURI2 = targetURI.resolve("/v2/spaces/" + spaceGuid + "/service_instances");
                    JSONObject services = ManifestUtils.getJSON(appJSON, "services", "applications");
                    String[] stringArray = JSONObject.getNames((JSONObject)services);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String plan;
                        String provider;
                        String servicePlanGUID;
                        serviceName = stringArray[n2];
                        String nameService = "name:" + (String)serviceName;
                        NameValuePair[] pa = new NameValuePair[]{new NameValuePair("return_user_provided_service_instance", "false"), new NameValuePair("q", nameService), new NameValuePair("inline-relations-depth", "2")};
                        GetMethod getServiceMethod = new GetMethod(serviceInstancesURI2.toString());
                        getServiceMethod.setQueryString(pa);
                        HttpUtil.configureHttpMethod((HttpMethod)getServiceMethod, this.target);
                        jobStatus = HttpUtil.executeMethod((HttpMethod)getServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        resp = jobStatus.getJsonData();
                        String serviceInstanceGUID = null;
                        JSONArray respArray = resp.getJSONArray("resources");
                        int i = 0;
                        while (i < respArray.length()) {
                            JSONObject str;
                            JSONObject o = respArray.optJSONObject(i);
                            if (o != null && (str = o.optJSONObject("metadata")) != null) {
                                serviceInstanceGUID = str.getString("guid");
                            }
                            ++i;
                        }
                        JSONObject serviceJSON = ManifestUtils.getJSON(services, (String)serviceName, "services");
                        String service = serviceJSON.optString("type");
                        if (service.isEmpty()) {
                            service = ManifestUtils.getString(serviceJSON, "label", (String)serviceName);
                        }
                        if ((servicePlanGUID = this.findServicePlanGUID(service, provider = ManifestUtils.getString(serviceJSON, "provider", (String)serviceName), plan = ManifestUtils.getString(serviceJSON, "plan", (String)serviceName), servicesJSON)) == null) {
                            String msg = NLS.bind((String)"Failed to find service {0} with plan {1} in target", (Object)service, (Object)plan);
                            status.add(new ServerStatus(4, 400, msg, null));
                            return this.revert(status);
                        }
                        URI serviceInstancesURI = targetURI.resolve("/v2/service_instances");
                        PostMethod createServiceMethod = new PostMethod(serviceInstancesURI.toString());
                        HttpUtil.configureHttpMethod((HttpMethod)createServiceMethod, this.target);
                        if (serviceInstanceGUID == null) {
                            JSONObject createServiceRequest = new JSONObject();
                            createServiceRequest.put("space_guid", (Object)this.target.getSpace().getCFJSON().getJSONObject("metadata").getString("guid"));
                            createServiceRequest.put("name", serviceName);
                            createServiceRequest.put("service_plan_guid", (Object)servicePlanGUID);
                            createServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(createServiceRequest.toString(), "application/json", "utf-8"));
                            jobStatus = HttpUtil.executeMethod((HttpMethod)createServiceMethod);
                            status.add(jobStatus);
                            if (!jobStatus.isOK()) {
                                return this.revert(status);
                            }
                            resp = jobStatus.getJsonData();
                            serviceInstanceGUID = resp.getJSONObject("metadata").getString("guid");
                        }
                        URI serviceBindingsURI = targetURI.resolve("/v2/service_bindings");
                        PostMethod bindServiceMethod = new PostMethod(serviceBindingsURI.toString());
                        HttpUtil.configureHttpMethod((HttpMethod)bindServiceMethod, this.target);
                        JSONObject bindServiceRequest = new JSONObject();
                        bindServiceRequest.put("app_guid", (Object)this.application.getGuid());
                        bindServiceRequest.put("service_instance_guid", (Object)serviceInstanceGUID);
                        bindServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(bindServiceRequest.toString(), "application/json", "utf-8"));
                        jobStatus = HttpUtil.executeMethod((HttpMethod)bindServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        ++n2;
                    }
                }
                if (version6 != null) {
                    spaceGuid = this.target.getSpace().getGuid();
                    URI serviceInstancesURI = targetURI.resolve("/v2/spaces/" + spaceGuid + "/service_instances");
                    int k = 0;
                    while (k < version6.length()) {
                        serviceName = version6.getJSONObject(k);
                        Iterator iter = serviceName.keys();
                        String nameService = null;
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            String value = (String)serviceName.get(key);
                            nameService = "name:" + (key != "" ? String.valueOf(key) + ":" : "") + value;
                        }
                        NameValuePair[] pa = new NameValuePair[]{new NameValuePair("return_user_provided_service_instance", "true"), new NameValuePair("q", nameService), new NameValuePair("inline-relations-depth", "2")};
                        GetMethod getServiceMethod = new GetMethod(serviceInstancesURI.toString());
                        getServiceMethod.setQueryString(pa);
                        HttpUtil.configureHttpMethod((HttpMethod)getServiceMethod, this.target);
                        jobStatus = HttpUtil.executeMethod((HttpMethod)getServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        resp = jobStatus.getJsonData();
                        String serviceInstanceGUID = null;
                        JSONArray respArray = resp.getJSONArray("resources");
                        int i = 0;
                        while (i < respArray.length()) {
                            JSONObject str;
                            JSONObject o = respArray.optJSONObject(i);
                            if (o != null && (str = o.optJSONObject("metadata")) != null) {
                                serviceInstanceGUID = str.getString("guid");
                            }
                            ++i;
                        }
                        if (serviceInstanceGUID == null) {
                            status.add(new ServerStatus(4, 400, "Service " + nameService + " can not be found", null));
                            return this.revert(status);
                        }
                        URI serviceBindingsURI = targetURI.resolve("/v2/service_bindings");
                        PostMethod bindServiceMethod = new PostMethod(serviceBindingsURI.toString());
                        HttpUtil.configureHttpMethod((HttpMethod)bindServiceMethod, this.target);
                        JSONObject bindServiceRequest = new JSONObject();
                        bindServiceRequest.put("app_guid", (Object)this.application.getGuid());
                        bindServiceRequest.put("service_instance_guid", (Object)serviceInstanceGUID);
                        bindServiceMethod.setRequestEntity((RequestEntity)new StringRequestEntity(bindServiceRequest.toString(), "application/json", "utf-8"));
                        jobStatus = HttpUtil.executeMethod((HttpMethod)bindServiceMethod);
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return this.revert(status);
                        }
                        ++k;
                    }
                }
            }
            return status;
        }
        catch (ParseException e) {
            status.add(new ServerStatus(4, 400, e.getMessage(), null));
            return this.revert(status);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return this.revert(status);
        }
    }

    private String findServicePlanGUID(String service, String provider, String plan, JSONArray servicesJSON) throws JSONException {
        int i = 0;
        while (i < servicesJSON.length()) {
            JSONObject serviceJSON = servicesJSON.getJSONObject(i).getJSONObject("entity");
            if (service.equals(serviceJSON.getString("label")) && provider.equals(serviceJSON.getString("provider"))) {
                JSONArray servicePlans = serviceJSON.getJSONArray("service_plans");
                int j = 0;
                while (j < servicePlans.length()) {
                    JSONObject servicePlan = servicePlans.getJSONObject(j);
                    if (plan.equals(servicePlan.getJSONObject("entity").getString("name"))) {
                        return servicePlan.getJSONObject("metadata").getString("guid");
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

