/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteApplicationRoutesCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Delete application route";
    private App application;
    private String appHost;
    private String appDomain;
    private String domainGUID;

    public DeleteApplicationRoutesCommand(Target target, App app) {
        super(target);
        this.application = app;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            if (this.appHost.isEmpty()) {
                return new ServerStatus(Status.OK_STATUS, 200);
            }
            ServerStatus getDomainJob = this.getDomainGUID();
            if (!getDomainJob.isOK()) {
                return getDomainJob;
            }
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI routesURI = targetURI.resolve("/v2/routes");
            GetMethod getRoutesMethod = new GetMethod(routesURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getRoutesMethod, this.target);
            getRoutesMethod.setQueryString("inline-relations-depth=1&results-per-page=1000");
            ServerStatus status = HttpUtil.executeMethod((HttpMethod)getRoutesMethod);
            if (!status.isOK()) {
                return status;
            }
            JSONArray routes = status.getJsonData().getJSONArray("resources");
            int i = 0;
            while (i < routes.length()) {
                JSONObject route = routes.getJSONObject(i);
                JSONObject routeEntity = route.getJSONObject("entity");
                if (routeEntity.getString("host").equals(this.appHost) && routeEntity.getString("domain_guid").equals(this.domainGUID)) {
                    String routeGUID = route.getJSONObject("metadata").getString("guid");
                    URI routeURI = targetURI.resolve("/v2/routes/" + routeGUID);
                    DeleteMethod deleteRouteMethod = new DeleteMethod(routeURI.toString());
                    HttpUtil.configureHttpMethod((HttpMethod)deleteRouteMethod, this.target);
                    status = HttpUtil.executeMethod((HttpMethod)deleteRouteMethod);
                    if (!status.isOK()) {
                        return status;
                    }
                }
                ++i;
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            JSONObject appJSON = ManifestUtils.getApplication(this.application.getManifest());
            this.appDomain = appJSON.optString("domain");
            String inputHost = appJSON.optString("host");
            this.appHost = !inputHost.isEmpty() ? inputHost : "";
            return Status.OK_STATUS;
        }
        catch (ParseException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }

    private ServerStatus getDomainGUID() {
        try {
            GetDomainsCommand getDomains = new GetDomainsCommand(this.target);
            ServerStatus status = (ServerStatus)getDomains.doIt();
            if (!status.isOK()) {
                return status;
            }
            JSONObject domains = status.getJsonData();
            if (domains.getInt("total_results") < 1) {
                return new ServerStatus(4, 400, "Failed to find available domains in target", null);
            }
            if (!this.appDomain.isEmpty()) {
                int resources = domains.getJSONArray("resources").length();
                int k = 0;
                while (k < resources) {
                    JSONObject resource = domains.getJSONArray("resources").getJSONObject(k);
                    String tmpDomainName = resource.getJSONObject("entity").getString("name");
                    if (this.appDomain.equals(tmpDomainName)) {
                        this.domainGUID = resource.getJSONObject("metadata").getString("guid");
                        break;
                    }
                    ++k;
                }
                if (this.domainGUID == null) {
                    String msg = NLS.bind((String)"Failed to find domain {1} in target", (Object)this.appDomain);
                    return new ServerStatus(4, 400, msg, null);
                }
            } else {
                JSONObject resource = domains.getJSONArray("resources").getJSONObject(0);
                this.domainGUID = resource.getJSONObject("metadata").getString("guid");
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

