/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDomainsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get available target domains";

    public GetDomainsCommand(Target target) {
        super(target);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String domainsURL = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("domains_url");
            URI domainsURI = targetURI.resolve(domainsURL);
            GetMethod getDomainsMethod = new GetMethod(domainsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getDomainsMethod, this.target);
            getDomainsMethod.setQueryString("inline-relations-depth=1");
            return HttpUtil.executeMethod((HttpMethod)getDomainsMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

