/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.ManifestNode;
import org.eclipse.orion.server.cf.manifest.ManifestParser;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManifestCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private App application;
    private String userId;
    private String contentLocation;

    public ParseManifestCommand(Target target, App app, String userId, String contentLocation) {
        super(target);
        this.application = app;
        this.userId = userId;
        this.contentLocation = contentLocation;
        this.commandName = NLS.bind((String)"Parse application manifest: {0}", (Object)contentLocation);
    }

    private ServerStatus canAccess(IPath contentPath) throws CoreException {
        String accessLocation = "/file/" + contentPath.toString();
        if (contentPath.segmentCount() < 1) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        if (!AuthorizationService.checkRights((String)this.userId, (String)accessLocation, (String)"GET")) {
            return new ServerStatus(4, 403, "Forbidden access to application contents", null);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            IPath contentPath = new Path(this.contentLocation).removeFirstSegments(1);
            ServerStatus accessStatus = this.canAccess(contentPath);
            if (!accessStatus.isOK()) {
                return accessStatus;
            }
            IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)contentPath);
            if (!fileStore.fetchInfo().isDirectory()) {
                fileStore = fileStore.getParent();
                contentPath = contentPath.removeLastSegments(1);
            }
            if (fileStore == null) {
                String msg = "Failed to find application manifest. If you have one, please select it or the folder that contains it before deploying.";
                return new ServerStatus(4, 400, msg, null);
            }
            IFileStore manifestStore = fileStore.getChild("manifest.yml");
            if (!manifestStore.fetchInfo().exists()) {
                String msg = "Failed to find application manifest. If you have one, please select it or the folder that contains it before deploying.";
                return new ServerStatus(4, 400, msg, null);
            }
            Scanner manifestScanner = new Scanner(manifestStore.openInputStream(0, null));
            ManifestNode manifestTree = ManifestParser.parse(manifestScanner);
            manifestScanner.close();
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            JSONObject manifest = manifestTree.toJSON(targetURI);
            JSONObject appJSON = ManifestUtils.getApplication(manifest);
            String path = appJSON.optString("path");
            if (path.isEmpty()) {
                path = ".";
            }
            try {
                IPath appStorePath = contentPath.append(path);
                accessStatus = this.canAccess(appStorePath);
                if (!accessStatus.isOK()) {
                    return accessStatus;
                }
                IFileStore appStore = NewFileServlet.getFileStore(null, (IPath)appStorePath);
                if (appStore == null) {
                    String msg = NLS.bind((String)"Failed to find application content due to incorrect path parameter: {0}", (Object)appStorePath);
                    return new ServerStatus(4, 400, msg, null);
                }
                this.application.setAppStore(appStore);
                this.application.setManifest(manifest);
            }
            catch (Exception exception) {
                return new ServerStatus(4, 400, "Failed to locate application contents as specified in the manifest.", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (ParseException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

