/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Org;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOrgCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Set Org";
    private String orgName;

    public SetOrgCommand(Target target, String orgName) {
        super(target);
        this.orgName = orgName;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI infoURI = URIUtil.toURI((URL)this.target.getUrl());
            infoURI = infoURI.resolve("/v2/organizations");
            GetMethod getMethod = new GetMethod(infoURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getMethod, this.target);
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject result = getStatus.getJsonData();
            JSONArray orgs = result.getJSONArray("resources");
            if (orgs.length() == 0) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            if (this.orgName == null || "".equals(this.orgName)) {
                JSONObject org = orgs.getJSONObject(0);
                this.target.setOrg(new Org().setCFJSON(org));
            } else {
                int i = 0;
                while (i < orgs.length()) {
                    JSONObject org = orgs.getJSONObject(i);
                    if (this.orgName.equals(org.getJSONObject("entity").getString("name"))) {
                        this.target.setOrg(new Org().setCFJSON(org));
                    }
                    ++i;
                }
            }
            if (this.target.getOrg() == null) {
                return new ServerStatus(4, 404, "Organization not found", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200, this.target.getOrg().toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

