/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;

public class ManifestNode {
    private List<ManifestNode> children = new ArrayList<ManifestNode>();
    private String label;
    private int depth;
    private int line;

    public ManifestNode(String label, int depth, int line) {
        this.label = label.trim();
        this.depth = depth;
        this.line = line;
    }

    public List<ManifestNode> getChildren() {
        return this.children;
    }

    public String getLabel() {
        return this.label;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int depth = this.getDepth();
        while (depth-- > 0) {
            sb.append(" ");
        }
        sb.append(this.getLabel());
        sb.append(System.getProperty("line.separator"));
        for (ManifestNode child : this.getChildren()) {
            sb.append(child.toString());
        }
        return sb.toString();
    }

    public JSONObject toJSON(URI target) throws ParseException {
        try {
            if (this.getChildren().isEmpty()) {
                JSONObject res = new JSONObject();
                String[] sLabel = ManifestUtils.splitLabel(this.label);
                if (sLabel.length < 2) {
                    sLabel = new String[]{"", sLabel[0]};
                }
                if (sLabel.length != 2) {
                    throw new ParseException(NLS.bind((String)"Unexpected token \"{0}\" (expected <key> : <value>)", (Object)this.label), this.line);
                }
                res.put(sLabel[0], (Object)ManifestUtils.normalize(ManifestUtils.resolve(sLabel[1], target)));
                return res;
            }
            if (this.isArrayNode()) {
                ArrayList<ArrayList<ManifestNode>> arrayItems = this.splitSequenceItems();
                JSONArray arrayRepresentation = new JSONArray();
                for (ArrayList<ManifestNode> item : arrayItems) {
                    JSONObject itemRepresentation = new JSONObject();
                    for (ManifestNode fieldNode : item) {
                        JSONObject representation = fieldNode.toJSON(target);
                        String key = JSONObject.getNames((JSONObject)representation)[0];
                        itemRepresentation.put(key, representation.get(key));
                    }
                    arrayRepresentation.put((Object)itemRepresentation);
                }
                JSONObject res = new JSONObject();
                String[] sLabel = ManifestUtils.splitLabel(this.label);
                if (sLabel.length != 1) {
                    throw new ParseException(NLS.bind((String)"Unexpected token \"{0}\" (expected group <key>:)", (Object)this.label), this.line);
                }
                res.put(sLabel[0], (Object)arrayRepresentation);
                return res;
            }
            JSONObject inner = new JSONObject();
            for (ManifestNode child : this.getChildren()) {
                JSONObject childNode = child.toJSON(target);
                String key = JSONObject.getNames((JSONObject)childNode)[0];
                inner.put(key, childNode.get(key));
            }
            JSONObject res = new JSONObject();
            String[] sLabel = ManifestUtils.splitLabel(this.label);
            res.put(sLabel[0], (Object)inner);
            return res;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ParseException();
        }
    }

    private boolean isSequenceItem() {
        return this.label.startsWith("- ");
    }

    private boolean isArrayNode() {
        ManifestNode firstChild = this.getChildren().get(0);
        return firstChild.isSequenceItem();
    }

    private ArrayList<ArrayList<ManifestNode>> splitSequenceItems() {
        ArrayList<ArrayList<ManifestNode>> res = new ArrayList<ArrayList<ManifestNode>>();
        for (ManifestNode child : this.getChildren()) {
            ArrayList<Object> seqItemList;
            if (child.isSequenceItem()) {
                seqItemList = new ArrayList<ManifestNode>();
                seqItemList.add(child);
                res.add(seqItemList);
                continue;
            }
            seqItemList = res.get(res.size() - 1);
            seqItemList.add(child);
        }
        return res;
    }
}

