/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.internal.server.servlets.workspace.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebUser;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.core.users.OrionScope;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibilityMetaStore
implements IMetaStore {
    private static List<String> INTERNAL_PROPERTIES = Arrays.asList("Name", "Id", "UserName", "ContentLocation", "SiteConfigurations");

    public void createProject(ProjectInfo info) throws CoreException {
        WebWorkspace workspace = WebWorkspace.fromId(info.getWorkspaceId());
        WebProject project = WebProject.fromId(WebProject.nextProjectId());
        info.setUniqueId(project.getId());
        this.updateProject(info);
        workspace.addProject(project);
        workspace.save();
    }

    public void createUser(UserInfo info) throws CoreException {
        if (info.getUniqueId() == null) {
            info.setUniqueId(WebUser.nextUserId());
        }
        WebUser.fromUserId(info.getUniqueId());
        this.updateUser(info);
    }

    public void createWorkspace(WorkspaceInfo info) throws CoreException {
        WebWorkspace workspace = WebUser.fromUserId(info.getUserId()).createWorkspace(info.getFullName());
        info.setUniqueId(workspace.getId());
    }

    public void deleteProject(String workspaceId, String projectName) throws CoreException {
        WebWorkspace workspace = WebWorkspace.fromId(workspaceId);
        WebProject project = workspace.getProjectByName(projectName);
        if (project == null) {
            return;
        }
        workspace.removeProject(project);
        project.remove();
        project.save();
        workspace.save();
    }

    public void deleteUser(String userId) throws CoreException {
        WebUser user = WebUser.fromUserId(userId);
        JSONArray workspaces = user.getWorkspacesJSON();
        int i = 0;
        while (i < workspaces.length()) {
            try {
                String workspaceId = workspaces.getJSONObject(i).getString("Id");
                this.deleteWorkspace(userId, workspaceId);
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        user.delete();
    }

    public void deleteWorkspace(String userId, String workspaceId) throws CoreException {
        if (!WebWorkspace.exists(workspaceId)) {
            return;
        }
        WebWorkspace workspace = WebWorkspace.fromId(workspaceId);
        for (WebProject project : workspace.getProjects()) {
            this.deleteProject(workspaceId, project.getName());
        }
        workspace.removeNode();
        WebUser.fromUserId(userId).deleteWorkspace(workspaceId);
    }

    private boolean isInternalProperty(String key) {
        return INTERNAL_PROPERTIES.contains(key);
    }

    public List<String> readAllUsers() throws CoreException {
        try {
            String[] children = new OrionScope().getNode("Users").childrenNames();
            return Arrays.asList(children);
        }
        catch (BackingStoreException e) {
            throw this.toCoreException(e);
        }
    }

    private CoreException toCoreException(BackingStoreException e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Error accessing preference store", (Throwable)e));
    }

    public ProjectInfo readProject(String workspaceId, String projectName) throws CoreException {
        WebWorkspace workspace = WebWorkspace.fromId(workspaceId);
        return this.toProjectInfo(workspace.getProjectByName(projectName));
    }

    private void readProperties(MetadataInfo info, IEclipsePreferences store) throws CoreException {
        try {
            String key;
            Preferences operationsNode = new OrionScope().getNode("Operations").node(info.getUniqueId());
            String[] stringArray = store.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                if (!this.isInternalProperty(key)) {
                    info.setProperty(key, store.get(key, null));
                }
                ++n2;
            }
            stringArray = operationsNode.keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                info.setProperty(key, operationsNode.get(key, null));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw this.toCoreException(e);
        }
    }

    public UserInfo readUser(String uid) throws CoreException {
        WebUser webUser = WebUser.fromUserId(uid);
        UserInfo info = new UserInfo();
        info.setUniqueId(webUser.getId());
        info.setFullName(webUser.getName());
        info.setUserName(webUser.getUserName());
        IEclipsePreferences store = webUser.getStore();
        this.readProperties((MetadataInfo)info, store);
        info.setProperty("UserRightsVersion", store.get("UserRightsVersion", null));
        info.setProperty("UserRights", store.get("UserRights", null));
        JSONArray workspaces = webUser.getWorkspacesJSON();
        ArrayList<String> workspaceIds = new ArrayList<String>(workspaces.length());
        int i = 0;
        while (i < workspaces.length()) {
            try {
                workspaceIds.add(workspaces.getJSONObject(i).getString("Id"));
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        info.setWorkspaceIds(workspaceIds);
        JSONArray sites = webUser.getSiteConfigurationsJSON(null);
        JSONObject sitesObject = new JSONObject();
        int i2 = 0;
        while (i2 < sites.length()) {
            try {
                JSONObject site = sites.getJSONObject(i2);
                sitesObject.put(site.getString("Id"), (Object)site);
            }
            catch (JSONException jSONException) {}
            ++i2;
        }
        info.setProperty("SiteConfigurations", sitesObject.toString());
        return info;
    }

    public WorkspaceInfo readWorkspace(String workspaceId) throws CoreException {
        if (!WebWorkspace.exists(workspaceId)) {
            return null;
        }
        WebWorkspace workspace = WebWorkspace.fromId(workspaceId);
        WorkspaceInfo info = new WorkspaceInfo();
        info.setUniqueId(workspaceId);
        info.setFullName(workspace.getName());
        ArrayList<String> projectNames = new ArrayList<String>();
        for (WebProject project : workspace.getProjects()) {
            projectNames.add(project.getName());
        }
        info.setProjectNames(projectNames);
        this.readProperties((MetadataInfo)info, workspace.getStore());
        return info;
    }

    private ProjectInfo toProjectInfo(WebProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        ProjectInfo info = new ProjectInfo();
        info.setUniqueId(project.getId());
        info.setFullName(project.getName());
        info.setContentLocation(project.getContentLocation());
        this.readProperties((MetadataInfo)info, project.getStore());
        return info;
    }

    public void updateProject(ProjectInfo projectInfo) throws CoreException {
        WebProject project = WebProject.fromId(projectInfo.getUniqueId());
        project.setContentLocation(projectInfo.getContentLocation());
        project.setName(projectInfo.getFullName());
        this.updateProperties((MetadataInfo)projectInfo, project.getStore());
        project.save();
    }

    private void updateProperties(MetadataInfo info, IEclipsePreferences store) throws CoreException {
        Map newProperties = info.getProperties();
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList<String> toRemoveOperations = new ArrayList<String>();
        try {
            toRemove.addAll(Arrays.asList(store.keys()));
        }
        catch (BackingStoreException e) {
            throw this.toCoreException(e);
        }
        Preferences operationsNode = new OrionScope().getNode("Operations").node(info.getUniqueId());
        try {
            toRemoveOperations.addAll(Arrays.asList(operationsNode.keys()));
        }
        catch (BackingStoreException e) {
            throw this.toCoreException(e);
        }
        for (String key : newProperties.keySet()) {
            Path keyPath;
            toRemove.remove(key);
            if (this.isInternalProperty(key)) continue;
            if (key.indexOf(47) >= 0 && "operations".equals((keyPath = new Path(key)).segment(0))) {
                toRemoveOperations.remove(key);
                operationsNode.put(key, (String)newProperties.get(key));
                continue;
            }
            store.put(key, (String)newProperties.get(key));
        }
        for (String key : toRemoveOperations) {
            operationsNode.remove(key);
        }
        try {
            operationsNode.flush();
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        for (String key : toRemove) {
            if (this.isInternalProperty(key)) continue;
            store.remove(key);
        }
    }

    private void updateSites(UserInfo info, WebUser webUser) throws CoreException {
        String sitesString = info.getProperty("SiteConfigurations");
        if (sitesString == null) {
            return;
        }
        JSONArray currentSites = webUser.getSiteConfigurationsJSON(null);
        try {
            JSONObject newSites = new JSONObject(sitesString);
            ArrayList<String> sitesToAdd = new ArrayList<String>();
            Iterator it = newSites.keys();
            while (it.hasNext()) {
                sitesToAdd.add((String)it.next());
            }
            int i = 0;
            while (i < currentSites.length()) {
                JSONObject currentSite = currentSites.getJSONObject(i);
                String currentSiteId = currentSite.getString("Id");
                JSONObject newSite = newSites.optJSONObject(currentSiteId);
                if (newSite == null) {
                    webUser.removeSiteConfiguration(webUser.getSiteConfiguration(currentSiteId));
                } else {
                    SiteConfiguration currentSiteConfig = webUser.getSiteConfiguration(currentSiteId);
                    SiteInfo newSiteInfo = SiteInfo.getSite(info, currentSiteId);
                    currentSiteConfig.update(newSiteInfo);
                }
                sitesToAdd.remove(currentSiteId);
                ++i;
            }
            for (String newSiteId : sitesToAdd) {
                SiteInfo newSiteInfo = SiteInfo.getSite(info, newSiteId);
                SiteConfiguration newSiteConfig = webUser.createSiteConfiguration(newSiteId, newSiteInfo.getName(), newSiteInfo.getWorkspace());
                newSiteConfig.update(newSiteInfo);
            }
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Malformed site configuration data", (Throwable)e));
        }
    }

    public void updateUser(UserInfo info) throws CoreException {
        String userId = info.getUniqueId();
        if (userId == null) {
            throw new IllegalArgumentException("User id not provided");
        }
        if (!WebUser.exists(userId)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Cannot update non-existent user: " + userId));
        }
        WebUser webUser = WebUser.fromUserId(userId);
        if (info.getUserName() != null) {
            webUser.setUserName(info.getUserName());
        }
        if (info.getFullName() != null) {
            webUser.setName(info.getFullName());
        }
        IEclipsePreferences store = webUser.getStore();
        this.updateProperties((MetadataInfo)info, store);
        this.updateSites(info, webUser);
        webUser.save();
    }

    public void updateWorkspace(WorkspaceInfo info) throws CoreException {
        WebWorkspace workspace = WebWorkspace.fromId(info.getUniqueId());
        this.updateProperties((MetadataInfo)info, workspace.getStore());
        workspace.save();
    }
}

