/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.UnsupportedUserStoreException;
import org.eclipse.orion.server.useradmin.User;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthHelper {
    private static IOrionCredentialsService userAdmin;
    private static IOrionUserProfileService userProfileService;

    public static LoginResult performAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException, UnsupportedUserStoreException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        String login = req.getParameter("login");
        User user = FormAuthHelper.getUserForCredentials(login, req.getParameter("password"));
        if (user != null) {
            if (user.getBlocked()) {
                return LoginResult.BLOCKED;
            }
            String userId = user.getUid();
            if (logger.isInfoEnabled()) {
                logger.info("Login success: " + login);
            }
            req.getSession().setAttribute("user", (Object)userId);
            IOrionUserProfileNode userProfileNode = FormAuthHelper.getUserProfileService().getUserProfileNode(userId, "general");
            try {
                userProfileNode.put("lastlogintimestamp", new Long(System.currentTimeMillis()).toString(), false);
                userProfileNode.flush();
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return LoginResult.OK;
        }
        if (login != null) {
            logger.info("Login failed: " + login);
        }
        return LoginResult.FAIL;
    }

    private static User getUserForCredentials(String login, String password) throws UnsupportedUserStoreException {
        if (userAdmin == null) {
            throw new UnsupportedUserStoreException();
        }
        User user = userAdmin.getUser("login", login);
        if (user != null && user.hasCredential("password", (Object)password)) {
            return user;
        }
        return null;
    }

    public static boolean canAddUsers() {
        boolean allowAnonymousAccountCreation;
        boolean bl = allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
        return allowAnonymousAccountCreation ? (userAdmin == null ? false : userAdmin.canCreateUsers()) : false;
    }

    public static boolean forceEmail() {
        return PreferenceHelper.getString((String)"orion.auth.user.creation.force.email", (String)"false").equalsIgnoreCase("true");
    }

    public static String registrationURI() {
        return PreferenceHelper.getString((String)"orion.auth.registration.uri", null);
    }

    public static IOrionCredentialsService getDefaultUserAdmin() {
        return userAdmin;
    }

    public void setUserAdmin(IOrionCredentialsService userAdmin) {
        FormAuthHelper.userAdmin = userAdmin;
    }

    public void unsetUserAdmin(IOrionCredentialsService userAdmin) {
        if (userAdmin.equals(FormAuthHelper.userAdmin)) {
            FormAuthHelper.userAdmin = null;
        }
    }

    public static JSONObject getUserJson(String uid, String contextPath) throws JSONException {
        User user;
        JSONObject obj;
        block5: {
            obj = new JSONObject();
            obj.put("login", (Object)uid);
            user = userAdmin.getUser("uid", uid);
            if (user != null) break block5;
            return null;
        }
        try {
            IOrionUserProfileNode generalUserProfile = FormAuthHelper.getUserProfileService().getUserProfileNode(uid, "general");
            obj.put("uid", (Object)uid);
            obj.put("login", (Object)user.getLogin());
            obj.put("Location", (Object)(String.valueOf(contextPath) + user.getLocation()));
            obj.put("Name", (Object)user.getName());
            if (generalUserProfile.get("lastlogintimestamp", null) != null) {
                Long lastLogin = Long.parseLong(generalUserProfile.get("lastlogintimestamp", ""));
                obj.put("lastlogintimestamp", (Object)lastLogin);
            }
        }
        catch (IllegalArgumentException e) {
            LogHelper.log((Throwable)e);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return obj;
    }

    private static IOrionUserProfileService getUserProfileService() {
        return userProfileService;
    }

    public static void bindUserProfileService(IOrionUserProfileService _userProfileService) {
        userProfileService = _userProfileService;
    }

    public static void unbindUserProfileService(IOrionUserProfileService userProfileService) {
        userProfileService = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoginResult {
        OK,
        FAIL,
        BLOCKED;

    }
}

