/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import com.jcraft.jsch.JSchException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.jsch.HostFingerprintException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GitJob
extends TaskJob {
    private static final String KEY_SCHEME = "Scheme";
    private static final String KEY_PORT = "Port";
    private static final String KEY_PASSWORD = "Password";
    public static final String KEY_HUMANISH_NAME = "HumanishName";
    public static final String KEY_URL = "Url";
    public static final String KEY_USER = "User";
    public static final String KEY_HOST = "Host";
    protected GitCredentialsProvider credentials;
    protected Cookie cookie;

    private static JSchException getJSchException(Throwable e) {
        if (e instanceof JSchException) {
            return (JSchException)e;
        }
        if (e.getCause() != null) {
            return GitJob.getJSchException(e.getCause());
        }
        return null;
    }

    private JSONObject addRepositoryInfo(JSONObject object) {
        try {
            if (this.credentials != null) {
                object.put(KEY_URL, (Object)this.credentials.getUri().toString());
                if (this.credentials.getUri().getUser() != null) {
                    object.put(KEY_USER, (Object)this.credentials.getUri().getUser());
                }
                if (this.credentials.getUri().getHost() != null) {
                    object.put(KEY_HOST, (Object)this.credentials.getUri().getHost());
                }
                if (this.credentials.getUri().getHumanishName() != null) {
                    object.put(KEY_HUMANISH_NAME, (Object)this.credentials.getUri().getHumanishName());
                }
                if (this.credentials.getUri().getPass() != null) {
                    object.put(KEY_PASSWORD, (Object)this.credentials.getUri().getPass());
                }
                if (this.credentials.getUri().getPort() > 0) {
                    object.put(KEY_PORT, this.credentials.getUri().getPort());
                }
                if (this.credentials.getUri().getScheme() != null) {
                    object.put(KEY_SCHEME, (Object)this.credentials.getUri().getScheme());
                }
            }
        }
        catch (JSONException jSONException) {}
        return object;
    }

    IStatus getExceptionStatus(Exception e, String message) {
        JSchException jschEx = GitJob.getJSchException(e);
        if (jschEx != null && jschEx instanceof HostFingerprintException) {
            HostFingerprintException cause = (HostFingerprintException)jschEx;
            return new ServerStatus(4, 400, cause.getMessage(), this.addRepositoryInfo(cause.formJson()), (Throwable)((Object)cause));
        }
        if (jschEx != null && jschEx.getMessage() != null && jschEx.getMessage().toLowerCase(Locale.ENGLISH).contains("auth fail")) {
            return new ServerStatus(4, 401, jschEx.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)jschEx);
        }
        if (e.getCause() instanceof TransportException) {
            TransportException cause = (TransportException)e.getCause();
            if (GitJob.matchMessage(JGitText.get().serviceNotPermitted, cause.getMessage())) {
                return new ServerStatus(4, 403, cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
            }
            if (GitJob.matchMessage(JGitText.get().notAuthorized, cause.getMessage())) {
                return new ServerStatus(4, 401, cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
            }
            if (cause.getMessage().endsWith("username must not be null.") || cause.getMessage().endsWith("host must not be null.")) {
                return new ServerStatus(4, 400, cause.getMessage(), this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
            }
            if (e instanceof GitAPIException) {
                return new ServerStatus(4, 500, message, this.addRepositoryInfo(new JSONObject()), (Throwable)e);
            }
            return new ServerStatus(4, 500, message, this.addRepositoryInfo(new JSONObject()), (Throwable)cause);
        }
        return new Status(4, "org.eclipse.orion.server.git", message, e.getCause() == null ? e : e.getCause());
    }

    IStatus getGitAPIExceptionStatus(GitAPIException e, String message) {
        return this.getExceptionStatus((Exception)((Object)e), message);
    }

    IStatus getJGitInternalExceptionStatus(JGitInternalException e, String message) {
        IStatus status = this.getExceptionStatus((Exception)((Object)e), message);
        return status;
    }

    public GitJob(String userRunningTask, boolean keep, GitCredentialsProvider credentials) {
        super(userRunningTask, keep);
        this.credentials = credentials;
        this.cookie = GitUtils.getSSOToken();
    }

    public GitJob(String userRunningTask, boolean keep) {
        this(userRunningTask, keep, null);
    }

    private static boolean matchMessage(String pattern, String message) {
        if (message == null) {
            return false;
        }
        int argsNum = 0;
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '{') {
                ++argsNum;
            }
            ++i;
        }
        Object[] args = new Object[argsNum];
        int i2 = 0;
        while (i2 < args.length) {
            args[i2] = ".*";
            ++i2;
        }
        return Pattern.matches(".*" + MessageFormat.format(pattern, args) + ".*", message);
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        GitUtils.setSSOToken(this.cookie);
        return super.run(progressMonitor);
    }
}

