/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class LogJob
extends GitJob {
    private IPath filePath;
    private URI cloneLocation;
    private int page;
    private int pageSize;
    private ObjectId toObjectId;
    private ObjectId fromObjectId;
    private Ref toRefId;
    private Ref fromRefId;
    private String refIdsRange;
    private String pattern;

    public LogJob(String userRunningTask, IPath filePath, URI cloneLocation, int page, int pageSize, ObjectId toObjectId, ObjectId fromObjectId, Ref toRefId, Ref fromRefId, String refIdsRange, String pattern) {
        super(userRunningTask, false);
        this.filePath = filePath;
        this.cloneLocation = cloneLocation;
        this.page = page;
        this.pageSize = pageSize;
        this.toObjectId = toObjectId;
        this.fromObjectId = fromObjectId;
        this.toRefId = toRefId;
        this.fromRefId = fromRefId;
        this.refIdsRange = refIdsRange;
        this.pattern = pattern;
        this.setFinalMessage("Generating git log completed.");
    }

    protected IStatus performJob() {
        Repository db = null;
        LogCommand logCommand = null;
        try {
            File gitDir = GitUtils.getGitDir(this.filePath);
            db = FileRepositoryBuilder.create((File)gitDir);
            Git git = new Git(db);
            logCommand = git.log();
            if (this.refIdsRange != null) {
                logCommand.add((AnyObjectId)this.toObjectId);
                if (this.fromObjectId != null) {
                    logCommand.not((AnyObjectId)this.fromObjectId);
                }
            } else {
                logCommand.all();
            }
            if (this.page > 0) {
                logCommand.setSkip((this.page - 1) * this.pageSize);
                logCommand.setMaxCount(this.pageSize + 1);
            }
            if (this.pattern != null && !this.pattern.isEmpty()) {
                logCommand.addPath(this.pattern);
            }
            Log log = new Log(this.cloneLocation, db, null, this.pattern, this.toRefId, this.fromRefId);
            log.setPaging(this.page, this.pageSize);
            Iterable commits = logCommand.call();
            log.setCommits(commits);
            JSONObject result = log.toJSON();
            ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
            return serverStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when generating log for ref {0}", (Object)logCommand.getRepository());
            Status status = new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
            return status;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

