/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.eclipse.orion.server.useradmin.User;
import org.eclipse.orion.server.useradmin.UserEmailUtil;
import org.eclipse.orion.server.useradmin.UserServiceHelper;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHandlerV1
extends ServletResourceHandler<String> {
    private static final int USERNAME_MIN_LENGTH = 3;
    private static final int USERNAME_MAX_LENGTH = 20;
    private ServletResourceHandler<IStatus> statusHandler;

    UserHandlerV1(UserServiceHelper userServiceHelper, ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String userPathInfo) throws ServletException {
        if (userPathInfo == null) {
            try {
                switch (UserHandlerV1.getMethod((HttpServletRequest)request)) {
                    case GET: {
                        return this.handleUsersGet(request, response);
                    }
                    case POST: {
                        return request.getParameter("reset") == null ? this.handleUserCreate(request, response) : this.handleUserReset(request, response);
                    }
                }
                return false;
            }
            catch (JSONException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
            }
            catch (Exception e) {
                throw new ServletException("Error handling users", (Throwable)e);
            }
        }
        String[] userPathInfoParts = userPathInfo.split("\\/", 2);
        if (userPathInfoParts.length > 2 && userPathInfoParts[2].equals("Roles")) {
            return false;
        }
        String userId = userPathInfoParts[1];
        try {
            switch (UserHandlerV1.getMethod((HttpServletRequest)request)) {
                case GET: {
                    return this.handleUserGet(request, response, userId);
                }
                case PUT: {
                    return this.handleUserPut(request, response, userId);
                }
                case DELETE: {
                    return this.handleUserDelete(request, response, userId);
                }
            }
            return false;
        }
        catch (JSONException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Syntax error in request", (Throwable)e));
        }
        catch (Exception e) {
            throw new ServletException(NLS.bind((String)"Error handling user: {0}", (Object)userId), (Throwable)e);
        }
    }

    private Collection<User> getAllUsers() {
        return this.getUserAdmin().getUsers();
    }

    private boolean handleUsersGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, JSONException, CoreException {
        Collection<User> users = this.getAllUsers();
        String startParam = req.getParameter("start");
        String rowsParam = req.getParameter("rows");
        boolean noStartParam = true;
        int start = 0;
        int rows = 0;
        int count = 0;
        if (startParam != null && startParam.length() != 0) {
            start = Integer.parseInt(startParam);
            if (start < 0) {
                start = 0;
            }
            noStartParam = false;
        } else {
            start = 0;
        }
        if (rowsParam != null && rowsParam.length() != 0) {
            rows = Integer.parseInt(rowsParam);
            if (rows < 0) {
                rows = 200;
            }
        } else {
            rows = noStartParam ? users.size() : 200;
        }
        ArrayList<JSONObject> userJSONs = new ArrayList<JSONObject>();
        URI location = ServletResourceHandler.getURI((HttpServletRequest)req);
        IOrionUserProfileNode userNode = null;
        for (User user : users) {
            if (count >= start + rows) break;
            if (count++ < start) continue;
            URI userLocation = URIUtil.append((URI)location, (String)user.getUid());
            userNode = this.getUserProfileService().getUserProfileNode(user.getUid(), true).getUserProfileNode("general");
            userJSONs.add(this.formJson(user, userNode, userLocation, req.getContextPath()));
        }
        JSONObject json = new JSONObject();
        json.put("users", userJSONs);
        json.put("users_start", start);
        json.put("users_rows", rows);
        json.put("users_length", users.size());
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)json);
        return true;
    }

    private boolean handleUserGet(HttpServletRequest req, HttpServletResponse resp, String userId) throws IOException, JSONException, ServletException, CoreException {
        User user = this.getUserAdmin().getUser("uid", userId);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 404, "User not found " + userId, null));
        }
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(userId, true).getUserProfileNode("general");
        URI location = ServletResourceHandler.getURI((HttpServletRequest)req);
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)this.formJson(user, userNode, location, req.getContextPath()));
        return true;
    }

    private boolean handleUserReset(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String login = req.getParameter("login");
        String password = req.getParameter("password");
        if (login == null || login.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User login not specified.", null));
        }
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("login", login);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 404, "User " + login + " could not be found.", null));
        }
        if (password == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Provide new password", null));
        }
        user.setPassword(password);
        IStatus status = userAdmin.updateUser(user.getUid(), user);
        if (!status.isOK()) {
            return this.statusHandler.handleRequest(req, resp, (Object)status);
        }
        return true;
    }

    private boolean handleUserCreate(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, CoreException {
        String msg;
        String login = req.getParameter("login");
        String name = req.getParameter("Name");
        String email = req.getParameter("email");
        String password = req.getParameter("password");
        boolean isEmailRequired = Boolean.TRUE.toString().equalsIgnoreCase(PreferenceHelper.getString((String)"orion.auth.user.creation.force.email"));
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        if (name == null) {
            name = login;
        }
        if ((msg = this.validateLogin(login)) != null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, msg, null));
        }
        if (password == null || password.length() == 0) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Cannot create user with empty password.", null));
        }
        if (isEmailRequired && (email == null || email.length() == 0)) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User email is mandatory.", null));
        }
        if (userAdmin.getUser("login", login) != null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + login + " already exists.", null));
        }
        if (email != null && email.length() > 0) {
            if (!email.contains("@")) {
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Invalid user email.", null));
            }
            if (userAdmin.getUser("email", email) != null) {
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, NLS.bind((String)"Email address already in use: {0}.", (Object)email), null));
            }
        }
        User newUser = new User(login, name, password);
        if (email != null && email.length() > 0) {
            newUser.setEmail(email);
        }
        if (isEmailRequired) {
            newUser.setBlocked(true);
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setUserName(login);
        userInfo.setFullName(name);
        OrionConfiguration.getMetaStore().createUser(userInfo);
        if (newUser.getUid() == null) {
            newUser.setUid(userInfo.getUniqueId());
        }
        if ((newUser = userAdmin.createUser(newUser)) == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, NLS.bind((String)"Error creating user: {0}", (Object)login), null));
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
        if (logger.isInfoEnabled()) {
            logger.info("Account created: " + login);
        }
        try {
            AuthorizationService.addUserRight((String)newUser.getUid(), (String)newUser.getLocation());
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User rights could not be added.", (Throwable)e));
        }
        URI userLocation = URIUtil.append((URI)ServletResourceHandler.getURI((HttpServletRequest)req), (String)newUser.getUid());
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(newUser.getUid(), true).getUserProfileNode("general");
        if (newUser.getBlocked()) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, newUser);
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 201, NLS.bind((String)"User {0} has been succesfully created. To log in please confirm your email first.", (Object)login), null));
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Could not send confirmation email to " + newUser.getEmail(), null));
            }
        }
        OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)this.formJson(newUser, userNode, userLocation, req.getContextPath()));
        if (email != null && email.length() > 0 && UserEmailUtil.getUtil().isEmailConfigured()) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, newUser);
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        return true;
    }

    private String validateLogin(String login) {
        if (login == null || login.length() == 0) {
            return "User login not specified";
        }
        int length = login.length();
        if (length < 3) {
            return NLS.bind((String)"Username must contain at least {0} characters", (Object)3);
        }
        if (length > 20) {
            return NLS.bind((String)"Username must contain no more than {0} characters", (Object)20);
        }
        if (login.equals("ultramegatron")) {
            return "Nice try, Mark";
        }
        int i = 0;
        while (i < length) {
            if (!Character.isLetterOrDigit(login.charAt(i))) {
                return NLS.bind((String)"Username {0} contains invalid character ''{1}''", (Object)login, (Object)Character.valueOf(login.charAt(i)));
            }
            ++i;
        }
        return null;
    }

    private boolean handleUserPut(HttpServletRequest req, HttpServletResponse resp, String userId) throws ServletException, IOException, CoreException, JSONException {
        IStatus status;
        JSONObject data = OrionServlet.readJSONRequest((HttpServletRequest)req);
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        User user = userAdmin.getUser("uid", userId);
        if (user == null) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + userId + " could not be found.", null));
        }
        String emailConfirmationid = user.getConfirmationId();
        if (!(this.isAdmin(req.getRemoteUser()) || !data.has("password") || user.getPassword() == null || data.has("oldPassword") && user.getPassword().equals(data.getString("oldPassword")))) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Invalid old password", null));
        }
        if (data.has("oldPassword") && (!data.has("password") || data.getString("password").length() == 0)) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Password cannot be empty", null));
        }
        if (data.has("login")) {
            user.setLogin(data.getString("login"));
        }
        if (data.has("Name")) {
            user.setName(data.getString("Name"));
        }
        if (data.has("password")) {
            user.setPassword(data.getString("password"));
        }
        if (data.has("email")) {
            user.setEmail(data.getString("email"));
        }
        if (data.has("properties")) {
            JSONObject propertiesObject = data.getJSONObject("properties");
            Iterator propertyIterator = propertiesObject.keys();
            while (propertyIterator.hasNext()) {
                String propertyKey = (String)propertyIterator.next();
                user.addProperty(propertyKey, propertiesObject.getString(propertyKey));
            }
        }
        if (!(status = userAdmin.updateUser(userId, user)).isOK()) {
            return this.statusHandler.handleRequest(req, resp, (Object)status);
        }
        IOrionUserProfileNode userNode = this.getUserProfileService().getUserProfileNode(userId, true).getUserProfileNode("general");
        if (userNode != null) {
            if (data.has("GitMail")) {
                userNode.put("GitMail", data.getString("GitMail"), false);
            }
            if (data.has("GitName")) {
                userNode.put("GitName", data.getString("GitName"), false);
            }
            userNode.flush();
        }
        if (user.getConfirmationId() != null && !user.getConfirmationId().equals(emailConfirmationid)) {
            try {
                UserEmailUtil.getUtil().sendEmailConfirmation(req, user);
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(1, 200, "Confirmation email has been sent to " + user.getEmail(), null));
            }
            catch (Exception e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Error while sending email" + (e.getMessage() == null ? "" : ": " + e.getMessage()) + ". See http://wiki.eclipse.org/Orion/Server_admin_guide#Email_configuration for email configuration guide."));
                return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "Could not send confirmation email to " + user.getEmail(), null));
            }
        }
        return true;
    }

    private boolean isAdmin(String user) {
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            String[] admins;
            String[] stringArray = admins = creators.split(",");
            int n = admins.length;
            int n2 = 0;
            while (n2 < n) {
                String admin = stringArray[n2];
                if (admin.equals(user)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean handleUserDelete(HttpServletRequest req, HttpServletResponse resp, String userId) throws ServletException {
        User user;
        IOrionCredentialsService userAdmin = this.getUserAdmin();
        if (!userAdmin.deleteUser(user = userAdmin.getUser("uid", userId))) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 400, "User " + userId + " could not be found.", null));
        }
        try {
            Activator.getDefault();
            IMetaStore metastore = OrionConfiguration.getMetaStore();
            metastore.deleteUser(userId);
        }
        catch (CoreException e) {
            return this.statusHandler.handleRequest(req, resp, (Object)new ServerStatus(4, 500, "Removing " + userId + " failed.", (Throwable)e));
        }
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
        if (logger.isInfoEnabled()) {
            logger.info("Account deleted: " + userId);
        }
        return true;
    }

    private JSONObject formJson(User user, IOrionUserProfileNode userProfile, URI location, String contextPath) throws JSONException, CoreException {
        JSONObject json = new JSONObject();
        json.put("uid", (Object)user.getUid());
        json.put("Location", (Object)location);
        json.put("Name", (Object)user.getName());
        json.put("login", (Object)user.getLogin());
        json.put("email", (Object)user.getEmail());
        json.put("emailConfirmed", user.isEmailConfirmed());
        json.put("hasPassword", user.getPassword() != null);
        JSONObject properties = new JSONObject();
        Enumeration<Object> userProperties = user.getProperties().keys();
        while (userProperties.hasMoreElements()) {
            String property = (String)userProperties.nextElement();
            properties.put(property, user.getProperty(property));
        }
        json.put("properties", (Object)properties);
        if (userProfile != null) {
            json.put("LastLogInTimestamp", (Object)userProfile.get("lastlogintimestamp", ""));
            json.put("GitMail", (Object)userProfile.get("GitMail", null));
            json.put("GitName", (Object)userProfile.get("GitName", null));
        }
        JSONArray plugins = new JSONArray();
        try {
            JSONObject plugin = new JSONObject();
            URI result = user.getPassword() == null ? new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), String.valueOf(contextPath) + "/plugins/user/nopasswordProfilePlugin.html", null, null) : new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), String.valueOf(contextPath) + "/plugins/user/userProfilePlugin.html", null, null);
            plugin.put("Url", (Object)result);
            plugins.put((Object)plugin);
        }
        catch (URISyntaxException e) {
            LogHelper.log((Throwable)e);
        }
        return json;
    }

    private IOrionCredentialsService getUserAdmin() {
        return UserServiceHelper.getDefault().getUserStore();
    }

    private IOrionUserProfileService getUserProfileService() {
        return UserServiceHelper.getDefault().getUserProfileService();
    }
}

