/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.internal.server.core.metastore.SimpleUserPasswordUtil;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaStoreMigration {
    private PrintStream migrationLog;
    private static final String METADATA_DIR = "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/";
    private static final String SECURESTORAGE = "/.metadata/.plugins/org.eclipse.orion.server.user.securestorage/user_store";
    public static final String ORION_STORAGE_PASSWORD = "orion.storage.password";
    public static final String PROMPT_USER = "org.eclipse.equinox.security.storage.promptUser";
    public static final String DEFAULT_PASSWORD = "org.eclipse.equinox.security.storage.defaultPassword";
    private ITaskService taskService;
    private ServiceReference<ITaskService> taskServiceRef;

    public boolean isMigrationRequired(File rootLocation) {
        File secureStorage = new File(rootLocation, SECURESTORAGE);
        File orionUserPrefsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Users.prefs");
        return secureStorage.exists() || orionUserPrefsFile.exists();
    }

    private void migrationLogClose() {
        this.migrationLog.close();
    }

    private void migrationLogOpen(File workspaceRoot) {
        try {
            File metadataFolder = new File(workspaceRoot, ".metadata");
            File logFile = new File(metadataFolder, "migration.log");
            FileOutputStream stream = new FileOutputStream(logFile);
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.info("Simple storage migration log is at " + logFile.getAbsolutePath());
            this.migrationLog = new PrintStream(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("SimpleMetaStoreMigration.migrationLogOpen: could not create migration log.");
        }
    }

    private void migrationLogPrint(String message) {
        this.migrationLog.println(message);
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        logger.debug(message);
    }

    public void doMigration(File rootLocation) {
        try {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.info("Starting simple storage migration.");
            this.migrationLogOpen(rootLocation);
            this.migrationLogPrint("Migrating MetaStore from legacy to simple.");
            this.getTaskService();
            File orionProjectPrefsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Projects.prefs");
            File orionWorkspacePrefsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Workspaces.prefs");
            File orionUserPrefsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Users.prefs");
            File orionSitesPrefsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/SiteConfigurations.prefs");
            File orionOperationsFile = new File(rootLocation, "/.metadata/.plugins/org.eclipse.orion.server.core/.settings/Operations.prefs");
            File orionSecureStorageFile = new File(rootLocation, SECURESTORAGE);
            Map<String, Map<String, String>> users = this.getMetadataFromPropertiesFile(orionUserPrefsFile);
            Map<String, Map<String, String>> usersSecureStorage = this.getMetadataFromSecureStorage(orionSecureStorageFile);
            Map<String, Map<String, String>> workspaces = this.getMetadataFromPropertiesFile(orionWorkspacePrefsFile);
            Map<String, Map<String, String>> projects = this.getMetadataFromPropertiesFile(orionProjectPrefsFile);
            Map<String, Map<String, String>> sites = this.getMetadataFromPropertiesFile(orionSitesPrefsFile);
            Map<String, Map<String, String>> operations = this.getMetadataFromPropertiesFile(orionOperationsFile);
            File metaStoreRootFolder = this.createOrUpdateMetaStoreRoot(rootLocation);
            int userSize = users.size();
            int userCount = 1;
            for (String userId : users.keySet()) {
                File userMetaFile;
                File newWorkspaceHome;
                Map<String, String> workspaceProperties;
                block27: {
                    String workspaceProjectProperty;
                    String userName;
                    block26: {
                        String encodedWorkspaceName;
                        Map<String, String> userProperties = users.get(userId);
                        Map<String, String> usersSecureStorageProperties = usersSecureStorage.get(userId);
                        userName = userProperties.get("UserName");
                        if (userName == null || userName.equals("") || userName.equals(userId) && userName.length() <= 2) {
                            String login;
                            if (usersSecureStorageProperties == null) {
                                this.migrationLogPrint("Processing UserId " + userId + " (" + userCount++ + " of " + userSize + ") ");
                                this.migrationLogPrint("ERROR: Did not migrate user: no UserName for userId: " + userId);
                                continue;
                            }
                            userName = login = usersSecureStorageProperties.get("login");
                            userProperties.put("UserName", login);
                            if (!userProperties.containsKey("Id")) {
                                userProperties.put("Id", login);
                            }
                        }
                        this.migrationLogPrint("Processing UserId " + userId + " (" + userCount++ + " of " + userSize + ") UserName " + userName);
                        File newUserHome = this.createOrUpdateUser(metaStoreRootFolder, userId, userProperties, usersSecureStorage, sites, operations);
                        if (newUserHome == null) {
                            this.migrationLogPrint("Did not migrate user: " + userName);
                            continue;
                        }
                        String userWorkspaceProperty = userProperties.get("Workspaces");
                        if (userWorkspaceProperty == null) {
                            this.migrationLogPrint("User " + userName + " has no workspaces.");
                            continue;
                        }
                        JSONObject workspaceObject = new JSONArray(userWorkspaceProperty).getJSONObject(0);
                        String workspaceId = workspaceObject.getString("Id");
                        workspaceProperties = workspaces.get(workspaceId);
                        if (workspaceProperties == null) {
                            workspaceProperties = new HashMap<String, String>();
                        }
                        if (!SimpleMetaStoreUtil.isMetaFolder(newUserHome, encodedWorkspaceName = "OrionContent")) {
                            SimpleMetaStoreUtil.createMetaFolder(newUserHome, encodedWorkspaceName);
                            this.migrationLogPrint("Created Workspace folder: " + SimpleMetaStoreUtil.readMetaFolder(newUserHome, encodedWorkspaceName).getAbsolutePath());
                        }
                        newWorkspaceHome = SimpleMetaStoreUtil.readMetaFolder(newUserHome, encodedWorkspaceName);
                        workspaceProjectProperty = workspaceProperties.get("Projects");
                        if (workspaceProjectProperty != null && !workspaceProjectProperty.equals("[]")) break block26;
                        this.migrationLogPrint("User " + userName + " has no projects.");
                        workspaceProperties.put("ProjectNames", "[]");
                        workspaceProperties.put("UserId", userName);
                        break block27;
                    }
                    JSONArray workspaceProjectsArray = new JSONArray(workspaceProjectProperty);
                    JSONArray projectNamesJSON = new JSONArray();
                    int i = 0;
                    while (i < workspaceProjectsArray.length()) {
                        block32: {
                            File projectMetaFile;
                            String newProjectId;
                            JSONObject newProjectJSON;
                            String projectName;
                            block30: {
                                block28: {
                                    File newContentLocation;
                                    File oldContentLocation;
                                    block33: {
                                        block31: {
                                            String contentLocation;
                                            block29: {
                                                JSONObject projectObject = workspaceProjectsArray.getJSONObject(i);
                                                String projectId = projectObject.getString("Id");
                                                Map<String, String> projectProperties = projects.get(projectId);
                                                projectName = projectProperties.get("Name");
                                                if (projectName.equals("workspace")) {
                                                    this.migrationLogPrint("Changed project name from: workspace to: workspace1 .");
                                                    projectName = "workspace1";
                                                    projectProperties.put("Name", projectName);
                                                }
                                                newProjectJSON = this.getProjectJSONfromProperties(projectProperties);
                                                newProjectId = newProjectJSON.getString("UniqueId");
                                                if (!newProjectJSON.has("ContentLocation")) break block28;
                                                contentLocation = newProjectJSON.getString("ContentLocation");
                                                if (!contentLocation.equals(projectId)) break block29;
                                                File oldContentLocation2 = new File(metaStoreRootFolder, contentLocation);
                                                File newContentLocation2 = SimpleMetaStoreUtil.retrieveMetaFolder(newWorkspaceHome, newProjectId);
                                                newProjectJSON.put("ContentLocation", (Object)newContentLocation2.toURI());
                                                oldContentLocation2.renameTo(newContentLocation2);
                                                this.migrationLogPrint("Moved Project folder: " + oldContentLocation2.getAbsolutePath() + " to: " + newContentLocation2.getAbsolutePath());
                                                break block30;
                                            }
                                            URI contentLocationURI = new URI(contentLocation);
                                            if (!contentLocationURI.getScheme().equals("file") || !(oldContentLocation = new File(contentLocationURI)).toString().startsWith(rootLocation.toString())) break block30;
                                            newContentLocation = SimpleMetaStoreUtil.retrieveMetaFolder(newWorkspaceHome, newProjectId);
                                            if (oldContentLocation.exists() && oldContentLocation.isDirectory()) break block31;
                                            this.migrationLogPrint("ERROR: Could not handle project folder: " + oldContentLocation.getAbsolutePath() + ": the folder does not exist.");
                                            break block32;
                                        }
                                        if (oldContentLocation.renameTo(newContentLocation)) break block33;
                                        this.migrationLogPrint("ERROR: Could not move project folder: " + oldContentLocation.getAbsolutePath() + " to: " + newContentLocation.getAbsolutePath() + ": bad project name: " + projectName);
                                        break block32;
                                    }
                                    this.migrationLogPrint("Moved Project folder: " + oldContentLocation.getAbsolutePath() + " to: " + newContentLocation.getAbsolutePath());
                                    newProjectJSON.put("ContentLocation", (Object)newContentLocation.toURI());
                                    break block30;
                                }
                                this.migrationLogPrint("ERROR: Skipped Project : " + projectName + ", the project has no ContentLocation.");
                                break block32;
                            }
                            newProjectJSON.put("WorkspaceId", (Object)(String.valueOf(userName) + "-OrionContent"));
                            if (SimpleMetaStoreUtil.isMetaFile(newWorkspaceHome, newProjectId)) {
                                SimpleMetaStoreUtil.updateMetaFile(newWorkspaceHome, newProjectId, newProjectJSON);
                                projectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(newWorkspaceHome, newProjectId);
                                this.migrationLogPrint("Updated project MetaData file: " + projectMetaFile.getAbsolutePath());
                                projectNamesJSON.put((Object)projectName);
                            } else if (!SimpleMetaStoreUtil.createMetaFile(newWorkspaceHome, newProjectId, newProjectJSON)) {
                                this.migrationLogPrint("ERROR: Skipped Project : " + projectName + ", could not save project json file, likely bad project name: " + projectName + ".");
                            } else {
                                projectMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(newWorkspaceHome, newProjectId);
                                this.migrationLogPrint("Created project MetaData file: " + projectMetaFile.getAbsolutePath());
                                projectNamesJSON.put((Object)projectName);
                            }
                        }
                        ++i;
                    }
                    workspaceProperties.put("ProjectNames", projectNamesJSON.toString());
                    workspaceProperties.put("UserId", userName);
                }
                JSONObject newWorkspaceJSON = this.getWorkspaceJSONfromProperties(workspaceProperties);
                if (SimpleMetaStoreUtil.isMetaFile(newWorkspaceHome, "workspace")) {
                    SimpleMetaStoreUtil.updateMetaFile(newWorkspaceHome, "workspace", newWorkspaceJSON);
                    userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(newWorkspaceHome, "workspace");
                    this.migrationLogPrint("Updated workspace MetaData file: " + userMetaFile.getAbsolutePath());
                    continue;
                }
                SimpleMetaStoreUtil.createMetaFile(newWorkspaceHome, "workspace", newWorkspaceJSON);
                userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(newWorkspaceHome, "workspace");
                this.migrationLogPrint("Created workspace MetaData file: " + userMetaFile.getAbsolutePath());
            }
            String[] metaStoreRootfiles = metaStoreRootFolder.list();
            int i = 0;
            while (i < metaStoreRootfiles.length) {
                File orgFolder = new File(metaStoreRootFolder, metaStoreRootfiles[i]);
                if (orgFolder.isDirectory() && !orgFolder.getName().equals(".metadata")) {
                    String[] orgFolderFiles = orgFolder.list();
                    int o = 0;
                    while (o < orgFolderFiles.length) {
                        File userFolder = new File(orgFolder, orgFolderFiles[o]);
                        if (userFolder.isDirectory()) {
                            String[] userFolderFiles = userFolder.list();
                            int u = 0;
                            while (u < userFolderFiles.length) {
                                String[] workspaceFolderFiles;
                                File workspaceFolder = new File(userFolder, userFolderFiles[u]);
                                if (workspaceFolder.isDirectory() && (workspaceFolderFiles = workspaceFolder.list()).length == 0) {
                                    workspaceFolder.delete();
                                    this.migrationLogPrint("Deleted empty workspace folder: " + workspaceFolder.getAbsolutePath());
                                }
                                ++u;
                            }
                            userFolderFiles = userFolder.list();
                            if (userFolderFiles.length == 0) {
                                userFolder.delete();
                                this.migrationLogPrint("Deleted empty user folder: " + userFolder.getAbsolutePath());
                            }
                        }
                        ++o;
                    }
                    orgFolderFiles = orgFolder.list();
                    if (orgFolderFiles.length == 0) {
                        orgFolder.delete();
                        this.migrationLogPrint("Deleted empty organization folder: " + orgFolder.getAbsolutePath());
                    }
                }
                ++i;
            }
            this.migrationLogClose();
            logger.info("Completed simple storage migration.");
        }
        catch (JSONException e) {
            LogHelper.log(e);
        }
        catch (URISyntaxException e) {
            LogHelper.log(e);
        }
    }

    private Map<String, Map<String, String>> getMetadataFromSecureStorage(File orionSecureStorageFile) {
        ISecurePreferences storage = this.initSecurePreferences(orionSecureStorageFile);
        HashMap<String, Map<String, String>> metaData = new HashMap<String, Map<String, String>>();
        ISecurePreferences usersSecureStorage = storage.node("users");
        String[] stringArray = usersSecureStorage.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uniqueId = stringArray[n2];
            try {
                ISecurePreferences generalUserProfile;
                String emailConfirmation;
                boolean blocked;
                ISecurePreferences userProfileNode = usersSecureStorage.node(uniqueId);
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                String login = userProfileNode.get("login", uniqueId);
                propertyMap.put("login", login);
                String name = userProfileNode.get("name", "");
                propertyMap.put("name", name);
                String password = userProfileNode.get("password", "");
                String encryptedPassword = SimpleUserPasswordUtil.encryptPassword(password);
                propertyMap.put("password", encryptedPassword);
                String email = userProfileNode.get("email", null);
                if (email != null) {
                    propertyMap.put("email", email);
                }
                if (blocked = userProfileNode.getBoolean("blocked", false)) {
                    propertyMap.put("blocked", "true");
                }
                if ((emailConfirmation = userProfileNode.get("email_confirmation", null)) != null) {
                    propertyMap.put("email_confirmation", emailConfirmation);
                }
                if ((generalUserProfile = userProfileNode.node("profile/general")) != null && generalUserProfile.get("lastlogintimestamp", null) != null) {
                    String lastlogintimestamp = generalUserProfile.get("lastlogintimestamp", "");
                    propertyMap.put("lastlogintimestamp", lastlogintimestamp);
                }
                if (generalUserProfile != null && generalUserProfile.get("GitName", null) != null) {
                    String gitName = generalUserProfile.get("GitName", "");
                    propertyMap.put("GitName", gitName);
                }
                if (generalUserProfile != null && generalUserProfile.get("GitMail", null) != null) {
                    String gitMail = generalUserProfile.get("GitMail", "");
                    propertyMap.put("GitMail", gitMail);
                }
                if (userProfileNode.nodeExists("properties")) {
                    JSONObject profileProperties = new JSONObject();
                    String[] stringArray2 = userProfileNode.node("properties").keys();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray2[n4];
                        String value = userProfileNode.node("properties").get(key, null);
                        profileProperties.put(key, (Object)value);
                        ++n4;
                    }
                    propertyMap.put("profileProperties", profileProperties.toString());
                }
                metaData.put(uniqueId, propertyMap);
            }
            catch (StorageException storageException) {
                this.migrationLogPrint("ERROR: StorageException reading user_store with userId: " + uniqueId);
            }
            catch (JSONException jSONException) {
                this.migrationLogPrint("ERROR: JSONException reading user_store with userId: " + uniqueId);
            }
            ++n2;
        }
        return metaData;
    }

    private ISecurePreferences initSecurePreferences(File orionSecureStorageFile) {
        try {
            ISecurePreferences storage = null;
            URL location = orionSecureStorageFile.toURI().toURL();
            if (location != null) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put(PROMPT_USER, Boolean.FALSE);
                String password = System.getProperty(ORION_STORAGE_PASSWORD, "");
                options.put(DEFAULT_PASSWORD, new PBEKeySpec(password.toCharArray()));
                try {
                    storage = SecurePreferencesFactory.open((URL)location, options);
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error initializing user storage location", (Throwable)e));
                }
            } else {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.core", "No instance location set. Storing user data in user home directory"));
            }
            return storage;
        }
        catch (MalformedURLException e1) {
            LogHelper.log(e1);
            return null;
        }
    }

    private Map<String, Map<String, String>> getMetadataFromPropertiesFile(File file) {
        HashMap<String, Map<String, String>> metaData = new HashMap<String, Map<String, String>>();
        if (file.exists()) {
            Properties properties = this.getPropertiesFromFile(file);
            for (Object key : properties.keySet()) {
                Map<String, String> propertyMap;
                String keyString = (String)key;
                if (keyString.equals("eclipse.preferences.version")) continue;
                String uniqueId = keyString.substring(0, keyString.indexOf("/"));
                String propertyKey = keyString.substring(keyString.indexOf("/") + 1);
                String propertyValue = properties.getProperty(keyString);
                if (metaData.containsKey(uniqueId)) {
                    propertyMap = (Map)metaData.get(uniqueId);
                    propertyMap.put(propertyKey, propertyValue);
                    continue;
                }
                propertyMap = new HashMap();
                propertyMap.put(propertyKey, propertyValue);
                metaData.put(uniqueId, propertyMap);
            }
        }
        return metaData;
    }

    private Properties getPropertiesFromFile(File file) {
        BufferedInputStream inStream;
        Properties properties = new Properties();
        try {
            inStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LogHelper.log(e);
            return null;
        }
        try {
            try {
                properties.load(inStream);
            }
            catch (IOException e) {
                LogHelper.log(e);
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    LogHelper.log(e2);
                    return null;
                }
                return null;
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                LogHelper.log(e);
                return null;
            }
        }
        return properties;
    }

    private File createOrUpdateMetaStoreRoot(File metaStoreRootFolder) {
        try {
            if (!SimpleMetaStoreUtil.isMetaFile(metaStoreRootFolder, "metastore")) {
                JSONObject metaStoreRootJSON = new JSONObject();
                metaStoreRootJSON.put("OrionVersion", 4);
                SimpleMetaStoreUtil.createMetaFile(metaStoreRootFolder, "metastore", metaStoreRootJSON);
                File rootMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(metaStoreRootFolder, "metastore");
                this.migrationLogPrint("Created root MetaData file: " + rootMetaFile.getAbsolutePath());
            }
            return metaStoreRootFolder;
        }
        catch (JSONException e) {
            LogHelper.log(e);
            return null;
        }
    }

    private File createOrUpdateUser(File metaStoreRootFolder, String userId, Map<String, String> userProperties, Map<String, Map<String, String>> usersSecureStorage, Map<String, Map<String, String>> sites, Map<String, Map<String, String>> operations) {
        File userMetaFolder;
        String userName = userProperties.get("UserName");
        JSONObject newUserJSON = this.getUserJSONfromProperties(userProperties, usersSecureStorage, sites, operations);
        if (newUserJSON == null) {
            return null;
        }
        if (!SimpleMetaStoreUtil.isMetaUserFolder(metaStoreRootFolder, userName)) {
            SimpleMetaStoreUtil.createMetaUserFolder(metaStoreRootFolder, userName);
        }
        if (SimpleMetaStoreUtil.isMetaFile(userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(metaStoreRootFolder, userName), "user")) {
            SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, "user", newUserJSON);
            File userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, "user");
            this.migrationLogPrint("Updated user MetaData file: " + userMetaFile.getAbsolutePath());
        } else {
            SimpleMetaStoreUtil.createMetaFile(userMetaFolder, "user", newUserJSON);
            File userMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, "user");
            this.migrationLogPrint("Created user MetaData file: " + userMetaFile.getAbsolutePath());
        }
        return userMetaFolder;
    }

    private ITaskService getTaskService() {
        if (this.taskService == null) {
            BundleContext context = Activator.getDefault().getContext();
            if (this.taskServiceRef == null) {
                this.taskServiceRef = context.getServiceReference(ITaskService.class);
                if (this.taskServiceRef == null) {
                    throw new IllegalStateException("Task service not available");
                }
            }
            this.taskService = (ITaskService)context.getService(this.taskServiceRef);
            if (this.taskService == null) {
                throw new IllegalStateException("Task service not available");
            }
        }
        return this.taskService;
    }

    private JSONObject getUserJSONfromProperties(Map<String, String> userProperties, Map<String, Map<String, String>> usersSecureStorage, Map<String, Map<String, String>> sites, Map<String, Map<String, String>> operations) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("OrionVersion", 4);
            String oldUserId = userProperties.get("Id");
            String userName = userProperties.get("UserName");
            userJSON.put("UserName", (Object)userName);
            userJSON.put("UniqueId", (Object)userName);
            Map<String, String> usersSecureStorageProperties = usersSecureStorage.get(oldUserId);
            if (usersSecureStorageProperties == null) {
                usersSecureStorageProperties = usersSecureStorage.get(userName);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("name")) {
                String secureStorageFullName = usersSecureStorageProperties.get("name");
                userJSON.put("FullName", (Object)secureStorageFullName);
            } else if (userProperties.containsKey("FullName")) {
                String fullName = usersSecureStorageProperties.get("FullName");
                userJSON.put("FullName", (Object)fullName);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("email")) {
                String secureStorageEmail = usersSecureStorageProperties.get("email");
                userJSON.put("email", (Object)secureStorageEmail);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("password")) {
                String secureStoragePassword = usersSecureStorageProperties.get("password");
                userJSON.put("password", (Object)secureStoragePassword);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("lastlogintimestamp")) {
                String lastlogintimestamp = usersSecureStorageProperties.get("lastlogintimestamp");
                userJSON.put("lastlogintimestamp", (Object)lastlogintimestamp);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("GitName")) {
                String gitName = usersSecureStorageProperties.get("GitName");
                userJSON.put("GitName", (Object)gitName);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("GitMail")) {
                String gitMail = usersSecureStorageProperties.get("GitMail");
                userJSON.put("GitMail", (Object)gitMail);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("blocked")) {
                String blocked = usersSecureStorageProperties.get("blocked");
                userJSON.put("blocked", (Object)blocked);
            }
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("email_confirmation")) {
                String email_confirmation = usersSecureStorageProperties.get("email_confirmation");
                userJSON.put("email_confirmation", (Object)email_confirmation);
            }
            userJSON.put("WorkspaceIds", (Object)new JSONArray());
            if (usersSecureStorageProperties != null && usersSecureStorageProperties.containsKey("profileProperties")) {
                String secureStorageProfileProperties = usersSecureStorageProperties.get("profileProperties");
                JSONObject jsonObject = new JSONObject(secureStorageProfileProperties);
                userJSON.put("profileProperties", (Object)jsonObject);
            }
            JSONObject properties = new JSONObject();
            for (String propertyKey : userProperties.keySet()) {
                String propertyValue = userProperties.get(propertyKey);
                if (propertyKey.equals("Id") || propertyKey.equals("UserName") || propertyKey.equals("Name") || propertyKey.equals("Guest")) continue;
                if (propertyKey.equals("UserRights")) {
                    JSONArray userRights = new JSONArray(propertyValue);
                    int i = 0;
                    while (i < userRights.length()) {
                        JSONObject userRight = userRights.getJSONObject(i);
                        String uri = userRight.getString("Uri");
                        if (uri.startsWith("/users/") && !uri.endsWith("*")) {
                            userRight.put("Uri", (Object)("/users/" + userName));
                        } else if (uri.startsWith("/workspace/") && !uri.endsWith("*")) {
                            userRight.put("Uri", (Object)("/workspace/" + userName + "-OrionContent"));
                        } else if (uri.startsWith("/workspace/") && uri.endsWith("*")) {
                            userRight.put("Uri", (Object)("/workspace/" + userName + "-OrionContent/*"));
                        } else if (uri.startsWith("/file/") && !uri.endsWith("*")) {
                            userRight.put("Uri", (Object)("/file/" + userName + "-OrionContent"));
                        } else if (uri.startsWith("/file/") && uri.endsWith("*")) {
                            userRight.put("Uri", (Object)("/file/" + userName + "-OrionContent/*"));
                        } else if (!uri.equals("/users/*") && !uri.equals("/users")) {
                            this.migrationLogPrint("Missed userRight: " + userRight);
                        }
                        ++i;
                    }
                    properties.put("UserRights", (Object)userRights);
                    continue;
                }
                if (propertyKey.equals("Workspaces")) {
                    JSONArray newWorkspacesJSON = new JSONArray();
                    newWorkspacesJSON.put((Object)(String.valueOf(userName) + "-OrionContent"));
                    userJSON.put("WorkspaceIds", (Object)newWorkspacesJSON);
                    continue;
                }
                if (propertyKey.equals("UserRightsVersion")) {
                    properties.put("UserRightsVersion", (Object)"3");
                    continue;
                }
                if (propertyKey.startsWith("SiteConfigurations")) {
                    JSONObject siteConfigurations = properties.has("SiteConfigurations") ? properties.getJSONObject("SiteConfigurations") : new JSONObject();
                    JSONObject newSite = new JSONObject();
                    Map<String, String> siteProperties = sites.get(propertyValue);
                    if (siteProperties == null) continue;
                    for (String sitePropertyKey : siteProperties.keySet()) {
                        String sitePropertyValue = siteProperties.get(sitePropertyKey);
                        if (sitePropertyKey.equals("Workspace")) {
                            newSite.put(sitePropertyKey, (Object)(String.valueOf(sitePropertyValue) + "-OrionContent"));
                            continue;
                        }
                        if (sitePropertyKey.equals("Mappings")) {
                            JSONArray mappings = new JSONArray(sitePropertyValue);
                            int i = 0;
                            int size = mappings.length();
                            while (i < size) {
                                JSONObject mapping = mappings.getJSONObject(i);
                                String target = mapping.getString("Target");
                                if (target.startsWith("/" + userName + "/")) {
                                    target = target.replace("/" + userName + "/", "/" + userName + "-OrionContent/");
                                    mapping.put("Target", (Object)target);
                                    mappings.put((Object)mapping);
                                }
                                ++i;
                            }
                            newSite.put(sitePropertyKey, (Object)mappings);
                            continue;
                        }
                        newSite.put(sitePropertyKey, (Object)sitePropertyValue);
                    }
                    siteConfigurations.put(propertyValue, (Object)newSite);
                    properties.put("SiteConfigurations", (Object)siteConfigurations);
                    continue;
                }
                if (propertyKey.startsWith("plugins//")) {
                    propertyKey = propertyKey.replace("plugins//", "plugins/");
                    properties.put(propertyKey, (Object)propertyValue);
                    continue;
                }
                if (propertyKey.startsWith("/")) {
                    properties.put(propertyKey.substring(1), (Object)propertyValue);
                    continue;
                }
                properties.put(propertyKey, (Object)propertyValue);
            }
            Map<String, String> operationProperties = operations.get(oldUserId);
            if (operationProperties != null) {
                ITaskService taskService = this.getTaskService();
                for (String operationPropertyKey : operationProperties.keySet()) {
                    String operationPropertyValue = operationProperties.get(operationPropertyKey);
                    String[] operation = operationPropertyKey.split("/");
                    String taskId = operation[operation.length - 1];
                    TaskInfo taskInfo = taskService.getTask(oldUserId, taskId, true);
                    if (taskInfo == null) {
                        this.migrationLogPrint("Deleted orphan operation that does not have a matching task: " + operationPropertyKey);
                        continue;
                    }
                    properties.put(operationPropertyKey, (Object)operationPropertyValue);
                }
            }
            userJSON.put("Properties", (Object)properties);
            return userJSON;
        }
        catch (JSONException e) {
            LogHelper.log(e);
            return null;
        }
    }

    private JSONObject getWorkspaceJSONfromProperties(Map<String, String> workspaceProperties) {
        try {
            JSONObject workspaceJSON = new JSONObject();
            workspaceJSON.put("OrionVersion", 4);
            String userId = workspaceProperties.get("UserId");
            workspaceJSON.put("UniqueId", (Object)(String.valueOf(userId) + "-OrionContent"));
            workspaceJSON.put("FullName", (Object)"Orion Content");
            workspaceJSON.put("UserId", (Object)userId);
            workspaceJSON.put("Properties", (Object)new JSONObject());
            JSONArray projectNames = new JSONArray(workspaceProperties.get("ProjectNames"));
            workspaceJSON.put("ProjectNames", (Object)projectNames);
            return workspaceJSON;
        }
        catch (JSONException e) {
            LogHelper.log(e);
            return null;
        }
    }

    private JSONObject getProjectJSONfromProperties(Map<String, String> projectProperties) {
        try {
            JSONObject projectJSON = new JSONObject();
            projectJSON.put("OrionVersion", 4);
            String contentLocation = projectProperties.get("ContentLocation");
            String name = projectProperties.get("Name");
            projectJSON.put("UniqueId", (Object)SimpleMetaStoreUtil.encodeProjectIdFromProjectName(name));
            projectJSON.put("FullName", (Object)name);
            projectJSON.put("ContentLocation", (Object)contentLocation);
            projectJSON.put("Properties", (Object)new JSONObject());
            return projectJSON;
        }
        catch (JSONException e) {
            LogHelper.log(e);
            return null;
        }
    }
}

