/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.metastore;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.core.metastore.MetadataInfo;

public class ProjectInfo
extends MetadataInfo {
    private URI contentLocation;
    private String workspaceId;

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public IFileStore getProjectStore() throws CoreException {
        return EFS.getStore((URI)this.getContentLocation());
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setContentLocation(URI contentURI) {
        if (contentURI.getUserInfo() == null) {
            this.contentLocation = contentURI;
        } else {
            try {
                this.contentLocation = new URI(contentURI.getScheme(), null, contentURI.getHost(), contentURI.getPort(), contentURI.getPath(), contentURI.getQuery(), contentURI.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }
}

