/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.osgi.service.prefs.BackingStoreException;

class WebProject
extends WebElement {
    public static final String PROJECT_NODE_NAME = "Projects";
    private static final Base64Counter projectCounter = new Base64Counter();

    public static WebProject fromId(String id) {
        WebProject result = new WebProject((IEclipsePreferences)scope.getNode(PROJECT_NODE_NAME).node(id));
        result.setId(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextProjectId() {
        Base64Counter base64Counter = projectCounter;
        synchronized (base64Counter) {
            String candidate;
            do {
                candidate = projectCounter.toString();
                projectCounter.increment();
            } while (WebProject.exists(candidate) || !caseSensitive && WebProject.containsUpperCase(candidate));
            return candidate;
        }
    }

    public static boolean exists(String id) {
        try {
            return scope.getNode(PROJECT_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public WebProject(IEclipsePreferences store) {
        super(store);
    }

    public void remove() {
        this.store.remove("ContentLocation");
        this.store.remove("Id");
        this.store.remove("Name");
    }

    public void removeNode() throws CoreException {
        try {
            IEclipsePreferences parent = (IEclipsePreferences)this.store.parent();
            this.store.clear();
            this.store.removeNode();
            parent.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error removing project", (Throwable)e));
        }
    }

    public void setContentLocation(URI contentURI) {
        if (contentURI == null) {
            this.store.remove("ContentLocation");
            return;
        }
        String uriString = null;
        if (contentURI.getUserInfo() == null) {
            uriString = contentURI.toString();
        } else {
            try {
                URI noCredentials = new URI(contentURI.getScheme(), null, contentURI.getHost(), contentURI.getPort(), contentURI.getPath(), contentURI.getQuery(), contentURI.getFragment());
                uriString = noCredentials.toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.store.put("ContentLocation", uriString);
    }

    public URI getContentLocation() {
        String location = this.store.get("ContentLocation", null);
        URI result = null;
        if (location != null) {
            try {
                result = new URI(location);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (result == null) {
            result = URI.create(this.getId());
        }
        if ("sftp".equals(result.getScheme())) {
            return result;
        }
        Path localPath = new Path(result.getPath());
        if (localPath.isAbsolute()) {
            return result;
        }
        IFileStore root = OrionConfiguration.getUserHome(null);
        return root.getChild(result.toString()).toURI();
    }

    public IFileStore getProjectStore(HttpServletRequest request) throws CoreException {
        URI location = this.getContentLocation();
        if (location.isAbsolute()) {
            String base64;
            String authString;
            String authHead;
            if (request != null && !"file".equals(location.getScheme()) && location.getUserInfo() == null && (authHead = request.getHeader("Authorization")) != null && authHead.toUpperCase(Locale.ENGLISH).startsWith("BASIC") && (authString = new String(Base64.decode((byte[])(base64 = authHead.substring(6)).getBytes()))).length() > 0) {
                try {
                    location = new URI(location.getScheme(), authString, location.getHost(), location.getPort(), location.getPath(), location.getQuery(), location.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return EFS.getStore((URI)location);
        }
        Path localPath = new Path(location.getPath());
        if (localPath.isAbsolute()) {
            return EFS.getLocalFileSystem().getStore((IPath)localPath);
        }
        IFileStore root = OrionConfiguration.getUserHome(null);
        return root.getChild(location.toString());
    }

    public IFileStore getProjectStore() throws CoreException {
        return this.getProjectStore(null);
    }
}

