/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.docker.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.orion.server.docker.server.DockerContainer;
import org.eclipse.orion.server.docker.server.DockerContainers;
import org.eclipse.orion.server.docker.server.DockerImage;
import org.eclipse.orion.server.docker.server.DockerImages;
import org.eclipse.orion.server.docker.server.DockerResponse;
import org.eclipse.orion.server.docker.server.DockerVersion;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerServer {
    private List<String> containerConnections;
    private URI dockerServer;
    private URI dockerProxy;

    public DockerServer(URI dockerServer, URI dockerProxy) {
        this.dockerServer = dockerServer;
        this.dockerProxy = dockerProxy;
        this.containerConnections = new ArrayList<String>();
    }

    public DockerResponse attachDockerContainer(String containerId, String originURL) {
        DockerResponse dockerResponse = new DockerResponse();
        try {
            String wsServer = this.dockerProxy.toString().replaceFirst("http", "ws");
            if (this.dockerProxy.toString().startsWith("https")) {
                wsServer = this.dockerProxy.toString().replaceFirst("https", "ws");
            }
            URI dockerAttachURI = new URI(String.valueOf(wsServer) + "/containers/" + containerId + "/attach/ws?stream=1&stdin=1&stdout=1&stderr=1");
            this.containerConnections.add(containerId);
            dockerResponse.setStatusCode(DockerResponse.StatusCode.ATTACHED);
            dockerResponse.setStatusMessage(dockerAttachURI.toString());
        }
        catch (URISyntaxException e) {
            this.setDockerResponse(dockerResponse, e);
        }
        catch (Exception e) {
            this.setDockerResponse(dockerResponse, e);
        }
        return dockerResponse;
    }

    public DockerContainer createDockerContainer(String imageName, String containerName, String userName, List<String> volumes) {
        DockerContainer dockerContainer = new DockerContainer();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                JSONObject requestJSONObject = new JSONObject();
                JSONArray cmdArray = new JSONArray();
                cmdArray.put((Object)"bash");
                requestJSONObject.put("Cmd", (Object)cmdArray);
                requestJSONObject.put("Image", (Object)imageName);
                requestJSONObject.put("User", (Object)userName);
                requestJSONObject.put("AttachStdin", true);
                requestJSONObject.put("AttachStdout", true);
                requestJSONObject.put("AttachStderr", true);
                requestJSONObject.put("Tty", true);
                requestJSONObject.put("OpenStdin", true);
                requestJSONObject.put("StdinOnce", true);
                if (volumes != null && !volumes.isEmpty()) {
                    JSONObject volumesObject = new JSONObject();
                    for (String volume : volumes) {
                        String orionVolume = volume.substring(volume.indexOf(58) + 1, volume.lastIndexOf(58));
                        volumesObject.put(orionVolume, (Object)new JSONObject());
                    }
                    requestJSONObject.put("Volumes", (Object)volumesObject);
                }
                byte[] outputBytes = requestJSONObject.toString().getBytes("UTF-8");
                URL dockerCreateContainerURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/create?name=" + containerName);
                httpURLConnection = (HttpURLConnection)dockerCreateContainerURL.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.connect();
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write(outputBytes);
                if (this.getDockerResponse(dockerContainer, httpURLConnection).equals((Object)DockerResponse.StatusCode.CREATED)) {
                    JSONObject jsonObject = this.readDockerResponseAsJSONObject(dockerContainer, httpURLConnection);
                    String id = jsonObject.getString("Id");
                    dockerContainer = this.getDockerContainer(id);
                    dockerContainer.setStatusCode(DockerResponse.StatusCode.CREATED);
                }
                outputStream.close();
            }
            catch (IOException e) {
                this.setDockerResponse(dockerContainer, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerContainer, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerContainer;
    }

    public DockerImage createDockerOrionBaseImage() {
        DockerImage dockerImage = new DockerImage();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                String line;
                URL createDockerOrionBaseImageURL = new URL(String.valueOf(this.dockerServer.toString()) + "/images/create?fromSrc&t=orion.base");
                httpURLConnection = (HttpURLConnection)createDockerOrionBaseImageURL.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("Content-Type", "application/tar");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.connect();
                String orionBaseTar = "/workspace/orion-dev/git/org.eclipse.orion.server/bundles/org.eclipse.orion.server.servlets/src/org/eclipse/orion/internal/server/servlets/docker/orion.base.tar";
                File orionBaseTarFile = new File(orionBaseTar);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8"));
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(orionBaseTarFile)));
                while ((line = reader.readLine()) != null) {
                    writer.print(line);
                }
                if (this.getDockerResponse(dockerImage, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONObject jsonObject = this.readDockerResponseAsJSONObject(dockerImage, httpURLConnection);
                    String id = jsonObject.getString("Id");
                    dockerImage = this.getDockerImage(id);
                    dockerImage.setStatusCode(DockerResponse.StatusCode.CREATED);
                }
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                this.setDockerResponse(dockerImage, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerImage, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerImage;
    }

    public DockerResponse deleteDockerContainer(String containerId) {
        DockerResponse dockerResponse = new DockerResponse();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerDeleteURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/" + containerId);
                httpURLConnection = (HttpURLConnection)dockerDeleteURL.openConnection();
                httpURLConnection.setRequestMethod("DELETE");
                httpURLConnection.connect();
                if (this.getDockerResponse(dockerResponse, httpURLConnection).equals((Object)DockerResponse.StatusCode.STARTED)) {
                    dockerResponse.setStatusCode(DockerResponse.StatusCode.DELETED);
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerResponse, e);
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerResponse;
    }

    public void detachDockerContainer(String user) {
        if (this.containerConnections.contains(user)) {
            this.containerConnections.remove(user);
        }
    }

    public DockerContainer getDockerContainer(String name) {
        DockerContainer dockerContainer = new DockerContainer();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerVersionURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/" + name + "/json?all=1");
                httpURLConnection = (HttpURLConnection)dockerVersionURL.openConnection();
                if (this.getDockerResponse(dockerContainer, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONObject jsonObject = this.readDockerResponseAsJSONObject(dockerContainer, httpURLConnection);
                    if (jsonObject.has("Id".toUpperCase())) {
                        dockerContainer.setId(jsonObject.getString("Id".toUpperCase()));
                    }
                    if (jsonObject.has("Image")) {
                        dockerContainer.setImage(jsonObject.getString("Image"));
                    }
                    if (jsonObject.has("Command")) {
                        dockerContainer.setCommand(jsonObject.getString("Command"));
                    } else if (jsonObject.has("Config")) {
                        JSONObject config = jsonObject.getJSONObject("Config");
                        JSONArray command = config.getJSONArray("Cmd");
                        dockerContainer.setCommand(command.getString(0));
                    }
                    if (jsonObject.has("Created")) {
                        dockerContainer.setCreated(jsonObject.getString("Created"));
                    }
                    if (jsonObject.has("Status")) {
                        dockerContainer.setStatus(jsonObject.getString("Status"));
                    } else if (jsonObject.has("State")) {
                        JSONObject state = jsonObject.getJSONObject("State");
                        Boolean running = state.getBoolean("Running");
                        String startedAt = state.getString("StartedAt");
                        String finishedAt = state.getString("FinishedAt");
                        if (!running.booleanValue() && finishedAt.endsWith("00Z")) {
                            dockerContainer.setStatus("Created at " + dockerContainer.getCreated());
                        } else if (running.booleanValue()) {
                            dockerContainer.setStatus("Started at " + startedAt);
                        } else if (!running.booleanValue()) {
                            dockerContainer.setStatus("Stopped at " + finishedAt);
                        }
                    }
                    if (jsonObject.has("Ports")) {
                        dockerContainer.setPorts(jsonObject.getString("Ports"));
                    }
                    if (jsonObject.has("SizeRw")) {
                        dockerContainer.setSize(jsonObject.getInt("SizeRw"));
                    }
                    if (jsonObject.has("SizeRootFs")) {
                        dockerContainer.setSize(jsonObject.getInt("SizeRootFs"));
                    }
                    if (jsonObject.has("Name")) {
                        dockerContainer.setName(jsonObject.getString("Name").substring(1));
                    }
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerContainer, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerContainer, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerContainer;
    }

    public DockerContainers getDockerContainers() {
        DockerContainers dockerContainers = new DockerContainers();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerVersionURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/json?all=1");
                httpURLConnection = (HttpURLConnection)dockerVersionURL.openConnection();
                if (this.getDockerResponse(dockerContainers, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONArray jsonArray = this.readDockerResponseAsJSONArray(dockerContainers, httpURLConnection);
                    int i = 0;
                    int isize = jsonArray.length();
                    while (i < isize) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        DockerContainer dockerContainer = new DockerContainer();
                        if (jsonObject.has("Id")) {
                            dockerContainer.setId(jsonObject.getString("Id"));
                        }
                        if (jsonObject.has("Image")) {
                            dockerContainer.setImage(jsonObject.getString("Image"));
                        }
                        if (jsonObject.has("Command")) {
                            dockerContainer.setCommand(jsonObject.getString("Command"));
                        }
                        if (jsonObject.has("Created")) {
                            long time = jsonObject.getLong("Created");
                            Date date = new Date(time);
                            SimpleDateFormat format = new SimpleDateFormat();
                            dockerContainer.setCreated(format.format((Object)date).toString());
                        }
                        if (jsonObject.has("Status")) {
                            dockerContainer.setStatus(jsonObject.getString("Status"));
                        }
                        if (jsonObject.has("Ports")) {
                            dockerContainer.setPorts(jsonObject.getString("Ports"));
                        }
                        if (jsonObject.has("SizeRw")) {
                            dockerContainer.setSize(jsonObject.getInt("SizeRw"));
                        }
                        if (jsonObject.has("SizeRootFs")) {
                            dockerContainer.setSize(jsonObject.getInt("SizeRootFs"));
                        }
                        if (jsonObject.has("Names")) {
                            JSONArray names = jsonObject.getJSONArray("Names");
                            String name = names.getString(0);
                            dockerContainer.setName(name.substring(1));
                        }
                        dockerContainers.addContainer(dockerContainer);
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerContainers, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerContainers, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerContainers;
    }

    public DockerImage getDockerImage(String repository) {
        DockerImage dockerImage = new DockerImage();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerVersionURL = new URL(String.valueOf(this.dockerServer.toString()) + "/images/" + repository + "/json");
                httpURLConnection = (HttpURLConnection)dockerVersionURL.openConnection();
                if (this.getDockerResponse(dockerImage, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONObject jsonObject = this.readDockerResponseAsJSONObject(dockerImage, httpURLConnection);
                    dockerImage.setRepository(repository);
                    if (jsonObject.has("Id".toLowerCase())) {
                        dockerImage.setId(jsonObject.getString("Id".toLowerCase()));
                    }
                    if (jsonObject.has("Created")) {
                        dockerImage.setCreated(jsonObject.getString("Created"));
                    }
                } else if (dockerImage.getStatusCode().equals((Object)DockerResponse.StatusCode.NO_SUCH_CONTAINER)) {
                    dockerImage.setStatusCode(DockerResponse.StatusCode.NO_SUCH_IMAGE);
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerImage, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerImage, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerImage;
    }

    public DockerImages getDockerImages() {
        DockerImages dockerImages = new DockerImages();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerVersionURL = new URL(String.valueOf(this.dockerServer.toString()) + "/images/json");
                httpURLConnection = (HttpURLConnection)dockerVersionURL.openConnection();
                if (this.getDockerResponse(dockerImages, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONArray jsonArray = this.readDockerResponseAsJSONArray(dockerImages, httpURLConnection);
                    int i = 0;
                    int isize = jsonArray.length();
                    while (i < isize) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        DockerImage dockerImage = new DockerImage();
                        if (jsonObject.has("Id")) {
                            dockerImage.setId(jsonObject.getString("Id"));
                        }
                        if (jsonObject.has("Created")) {
                            long time = jsonObject.getLong("Created");
                            Date date = new Date(time);
                            SimpleDateFormat format = new SimpleDateFormat();
                            dockerImage.setCreated(format.format((Object)date).toString());
                        }
                        if (jsonObject.has("Size")) {
                            dockerImage.setSize(jsonObject.getLong("Size"));
                        }
                        if (jsonObject.has("VirtualSize")) {
                            dockerImage.setVirtualSize(jsonObject.getLong("VirtualSize"));
                        }
                        if (jsonObject.has("RepoTags")) {
                            JSONArray repotags = jsonObject.getJSONArray("RepoTags");
                            int j = 0;
                            int jsize = repotags.length();
                            while (j < jsize) {
                                String[] repoTag = repotags.getString(j).split(":");
                                if (j == 0) {
                                    dockerImage.setRepository(repoTag[0]);
                                    dockerImage.setTag(repoTag[1]);
                                } else {
                                    DockerImage nextDockerImage = new DockerImage();
                                    nextDockerImage.setId(dockerImage.getId());
                                    nextDockerImage.setCreated(dockerImage.getCreated());
                                    nextDockerImage.setSize(dockerImage.getSize());
                                    nextDockerImage.setRepository(dockerImage.getRepository());
                                    nextDockerImage.setTag(repoTag[1]);
                                    dockerImages.addImage(nextDockerImage);
                                }
                                ++j;
                            }
                        }
                        dockerImages.addImage(dockerImage);
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerImages, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerImages, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerImages;
    }

    private DockerResponse.StatusCode getDockerResponse(DockerResponse dockerResponse, HttpURLConnection httpURLConnection) {
        try {
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.OK);
                return DockerResponse.StatusCode.OK;
            }
            if (responseCode == 201) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.CREATED);
                return DockerResponse.StatusCode.CREATED;
            }
            if (responseCode == 204) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.STARTED);
                return DockerResponse.StatusCode.STARTED;
            }
            if (responseCode == 400) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.BAD_PARAMETER);
                dockerResponse.setStatusMessage(httpURLConnection.getResponseMessage());
                return DockerResponse.StatusCode.BAD_PARAMETER;
            }
            if (responseCode == 404) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.NO_SUCH_CONTAINER);
                dockerResponse.setStatusMessage(httpURLConnection.getResponseMessage());
                return DockerResponse.StatusCode.NO_SUCH_CONTAINER;
            }
            if (responseCode == 500) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
                dockerResponse.setStatusMessage(httpURLConnection.getResponseMessage());
                return DockerResponse.StatusCode.SERVER_ERROR;
            }
            throw new RuntimeException("Unknown status code :" + responseCode);
        }
        catch (IOException e) {
            this.setDockerResponse(dockerResponse, e);
            if (e instanceof ConnectException && e.getLocalizedMessage().contains("Connection refused")) {
                dockerResponse.setStatusCode(DockerResponse.StatusCode.CONNECTION_REFUSED);
                return DockerResponse.StatusCode.CONNECTION_REFUSED;
            }
            return DockerResponse.StatusCode.SERVER_ERROR;
        }
    }

    public URI getDockerServer() {
        return this.dockerServer;
    }

    public DockerVersion getDockerVersion() {
        DockerVersion dockerVersion = new DockerVersion();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerVersionURL = new URL(String.valueOf(this.dockerServer.toString()) + "/version");
                httpURLConnection = (HttpURLConnection)dockerVersionURL.openConnection();
                if (this.getDockerResponse(dockerVersion, httpURLConnection).equals((Object)DockerResponse.StatusCode.OK)) {
                    JSONObject jsonObject = this.readDockerResponseAsJSONObject(dockerVersion, httpURLConnection);
                    if (jsonObject.has("Version")) {
                        dockerVersion.setVersion(jsonObject.getString("Version"));
                    }
                    if (jsonObject.has("GitCommit")) {
                        dockerVersion.setGitCommit(jsonObject.getString("GitCommit"));
                    }
                    if (jsonObject.has("GoVersion")) {
                        dockerVersion.setGoVersion(jsonObject.getString("GoVersion"));
                    }
                }
            }
            catch (IOException e) {
                dockerVersion.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
                dockerVersion.setStatusMessage(e.getLocalizedMessage());
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                dockerVersion.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
                dockerVersion.setStatusMessage(e.getLocalizedMessage());
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerVersion;
    }

    public boolean isAttachedDockerContainer(String user) {
        return this.containerConnections.contains(user);
    }

    private JSONArray readDockerResponseAsJSONArray(DockerResponse dockerResponse, HttpURLConnection httpURLConnection) {
        try {
            String dockerResponseAsString = this.readDockerResponseAsString(dockerResponse, httpURLConnection);
            JSONArray jsonArray = new JSONArray(dockerResponseAsString);
            return jsonArray;
        }
        catch (JSONException e) {
            dockerResponse.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
            dockerResponse.setStatusMessage(e.getLocalizedMessage());
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return new JSONArray();
        }
    }

    private JSONObject readDockerResponseAsJSONObject(DockerResponse dockerResponse, HttpURLConnection httpURLConnection) {
        try {
            String dockerResponseAsString = this.readDockerResponseAsString(dockerResponse, httpURLConnection);
            JSONObject jsonObject = new JSONObject(dockerResponseAsString);
            return jsonObject;
        }
        catch (JSONException e) {
            dockerResponse.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
            dockerResponse.setStatusMessage(e.getLocalizedMessage());
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return new JSONObject();
        }
    }

    private String readDockerResponseAsString(DockerResponse dockerResponse, HttpURLConnection httpURLConnection) {
        try {
            int count;
            InputStream inputStream = httpURLConnection.getInputStream();
            char[] chars = new char[1024];
            Charset utf8 = Charset.forName("UTF-8");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, utf8);
            StringBuilder stringBuilder = new StringBuilder();
            while ((count = inputStreamReader.read(chars, 0, chars.length)) != -1) {
                stringBuilder.append(chars, 0, count);
            }
            inputStreamReader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            dockerResponse.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
            dockerResponse.setStatusMessage(e.getLocalizedMessage());
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return "{}";
        }
    }

    private void setDockerResponse(DockerResponse dockerResponse, Exception e) {
        dockerResponse.setStatusCode(DockerResponse.StatusCode.SERVER_ERROR);
        dockerResponse.setStatusMessage(e.getLocalizedMessage());
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
        logger.error(e.getLocalizedMessage(), (Throwable)e);
    }

    public DockerContainer startDockerContainer(String containerId, List<String> binds) {
        DockerContainer dockerContainer = new DockerContainer();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                JSONObject requestJSONObject = new JSONObject();
                if (binds != null && !binds.isEmpty()) {
                    JSONArray bindsArray = new JSONArray();
                    for (String volume : binds) {
                        bindsArray.put((Object)volume);
                    }
                    requestJSONObject.put("Binds", (Object)bindsArray);
                }
                byte[] outputBytes = requestJSONObject.toString().getBytes("UTF-8");
                URL dockerStartURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/" + containerId + "/start");
                httpURLConnection = (HttpURLConnection)dockerStartURL.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.connect();
                OutputStream outputStream = httpURLConnection.getOutputStream();
                outputStream.write(outputBytes);
                if (this.getDockerResponse(dockerContainer, httpURLConnection).equals((Object)DockerResponse.StatusCode.STARTED)) {
                    dockerContainer = this.getDockerContainer(containerId);
                    dockerContainer.setStatusCode(DockerResponse.StatusCode.STARTED);
                } else if (dockerContainer.getStatusCode().equals((Object)DockerResponse.StatusCode.SERVER_ERROR) && (dockerContainer = this.getDockerContainer(containerId)).getStatus().startsWith("Started at")) {
                    dockerContainer.setStatusCode(DockerResponse.StatusCode.RUNNING);
                }
                outputStream.close();
            }
            catch (IOException e) {
                this.setDockerResponse(dockerContainer, e);
                httpURLConnection.disconnect();
            }
            catch (JSONException e) {
                this.setDockerResponse(dockerContainer, (Exception)((Object)e));
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerContainer;
    }

    public DockerContainer stopDockerContainer(String containerId) {
        DockerContainer dockerContainer = new DockerContainer();
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                URL dockerStartURL = new URL(String.valueOf(this.dockerServer.toString()) + "/containers/" + containerId + "/stop?t=0");
                httpURLConnection = (HttpURLConnection)dockerStartURL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.connect();
                if (this.getDockerResponse(dockerContainer, httpURLConnection).equals((Object)DockerResponse.StatusCode.STARTED)) {
                    dockerContainer = this.getDockerContainer(containerId);
                    dockerContainer.setStatusCode(DockerResponse.StatusCode.STOPPED);
                }
            }
            catch (IOException e) {
                this.setDockerResponse(dockerContainer, e);
                httpURLConnection.disconnect();
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return dockerContainer;
    }
}

