/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Log;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLogsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get App Logs";
    private String applicationName;
    private String logFileName;
    private String baseRequestLocation;

    public GetLogsCommand(Target target, String applicationName, String logFileName, String baseRequestLocation) {
        super(target);
        this.applicationName = applicationName;
        this.logFileName = logFileName;
        this.baseRequestLocation = baseRequestLocation;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appsUrl = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
            URI appsURI = targetURI.resolve(appsUrl);
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.target);
            getAppsMethod.setQueryString("q=name:" + this.applicationName + "&inline-relations-depth=1");
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getAppsMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject apps = getStatus.getJsonData();
            if (apps.has("error_code")) {
                return new ServerStatus(4, 500, apps.optString("description"), apps, null);
            }
            if (!apps.has("resources") || apps.getJSONArray("resources").length() == 0) {
                return new ServerStatus(4, 404, "Application does not exist on the server", null);
            }
            JSONObject app = apps.getJSONArray("resources").getJSONObject(0).getJSONObject("metadata");
            String instancesAppUrl = String.valueOf(app.getString("url")) + "/instances";
            URI instancesAppURI = targetURI.resolve(instancesAppUrl);
            GetMethod getInstancesMethod = new GetMethod(instancesAppURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getInstancesMethod, this.target);
            getStatus = HttpUtil.executeMethod((HttpMethod)getInstancesMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject instances = getStatus.getJsonData();
            if (instances.has("error_code")) {
                return new ServerStatus(4, 500, instances.optString("description"), instances, null);
            }
            Iterator instancesIterator = instances.keys();
            JSONObject jsonResp = new JSONObject();
            while (instancesIterator.hasNext()) {
                String instance = (String)instancesIterator.next();
                String instanceLogsAppUrl = String.valueOf(app.getString("url")) + "/instances/" + instance + "/files/logs";
                if (this.logFileName != null) {
                    instanceLogsAppUrl = String.valueOf(instanceLogsAppUrl) + "/" + this.logFileName;
                }
                URI instanceLogsAppURI = targetURI.resolve(instanceLogsAppUrl);
                GetMethod getInstanceLogsMethod = new GetMethod(instanceLogsAppURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getInstanceLogsMethod, this.target);
                getStatus = HttpUtil.executeMethod((HttpMethod)getInstanceLogsMethod);
                if (!getStatus.isOK()) {
                    return getStatus;
                }
                String response = getStatus.getJsonData().optString("response");
                if (response == null) {
                    return new ServerStatus(4, 500, "Log request: invalid response from the server", getStatus.getJsonData(), null);
                }
                if (this.logFileName == null) {
                    JSONArray logs = new JSONArray();
                    String[] logFiles = response.split("\n");
                    int i = 0;
                    while (i < logFiles.length) {
                        String logFileEntry = logFiles[i];
                        String[] logFileEntryParts = logFileEntry.split("\\s+");
                        if (logFileEntryParts.length == 2) {
                            Log log = new Log(this.applicationName, logFileEntryParts[0]);
                            URI baseUri = new URI(this.baseRequestLocation.endsWith("/") ? this.baseRequestLocation : String.valueOf(this.baseRequestLocation) + "/");
                            log.setLocation(baseUri.resolve(log.getName()));
                            log.setSize(logFileEntryParts[1]);
                            logs.put((Object)log.toJSON());
                        }
                        ++i;
                    }
                    jsonResp.put(instance, (Object)logs);
                    continue;
                }
                Log log = new Log(this.applicationName, this.logFileName);
                log.setContents(response);
                log.setLocation(new URI(this.baseRequestLocation));
                jsonResp.put(instance, (Object)log.toJSON());
            }
            return new ServerStatus(Status.OK_STATUS, 200, jsonResp);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

