/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSpaceCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Login";
    private String spaceName;

    public SetSpaceCommand(Target target, String spaceName) {
        super(target);
        this.spaceName = spaceName;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String spaceUrl = this.target.getOrg().getCFJSON().getJSONObject("entity").getString("spaces_url");
            URI spaceURI = targetURI.resolve(spaceUrl);
            GetMethod getMethod = new GetMethod(spaceURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getMethod, this.target);
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethod)getMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject result = getStatus.getJsonData();
            JSONArray spaces = result.getJSONArray("resources");
            if (spaces.length() == 0) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            if (this.spaceName == null || "".equals(this.spaceName)) {
                JSONObject space = spaces.getJSONObject(0);
                this.target.setSpace(new Space().setCFJSON(space));
            } else {
                int i = 0;
                while (i < spaces.length()) {
                    JSONObject space = spaces.getJSONObject(i);
                    if (this.spaceName.equals(space.getJSONObject("entity").getString("name"))) {
                        this.target.setSpace(new Space().setCFJSON(space));
                    }
                    ++i;
                }
            }
            if (this.target.getSpace() == null) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200, this.target.getSpace().toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

