/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.server.cf.commands.AbstractRevertableCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadBitsCommand
extends AbstractRevertableCFCommand {
    private static final int MAX_ATTEMPTS = 150;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;

    public UploadBitsCommand(Target target, App app) {
        super(target, app);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Upload application {0} bits (guid: {1})", (Object[])bindings);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            File appPackage = this.getAppPackage(this.application.getAppStore());
            if (appPackage == null) {
                status.add(new ServerStatus(4, 500, "Failed to read application content", null));
                return this.revert(status);
            }
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            PutMethod uploadMethod = new PutMethod(targetURI.resolve("/v2/apps/" + this.application.getGuid() + "/bits?async=true").toString());
            uploadMethod.addRequestHeader(new Header("Authorization", "bearer " + this.target.getCloud().getAccessToken().getString("access_token")));
            Part[] parts = new Part[]{new StringPart("resources", "[]"), new FilePart("application", appPackage)};
            uploadMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, uploadMethod.getParams()));
            ServerStatus jobStatus = HttpUtil.executeMethod((HttpMethod)uploadMethod);
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return this.revert(status);
            }
            int attemptsLeft = 150;
            JSONObject resp = jobStatus.getJsonData();
            String taksStatus = resp.getJSONObject("entity").getString("status");
            while (!"finished".equals(taksStatus) && !"failure".equals(taksStatus)) {
                if ("failed".equals(taksStatus)) {
                    appPackage.delete();
                    status.add(new ServerStatus(4, 400, "Upload failed", null));
                    return status;
                }
                if (attemptsLeft == 0) {
                    appPackage.delete();
                    status.add(new ServerStatus(4, 400, "Upload timeout exceeded", null));
                    return this.revert(status);
                }
                Thread.sleep(2000L);
                URI jobLocation = targetURI.resolve(resp.getJSONObject("metadata").getString("url"));
                GetMethod jobRequest = new GetMethod(jobLocation.toString());
                HttpUtil.configureHttpMethod((HttpMethod)jobRequest, this.target);
                jobStatus = HttpUtil.executeMethod((HttpMethod)jobRequest);
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return this.revert(status);
                }
                resp = jobStatus.getJsonData();
                taksStatus = resp.getJSONObject("entity").getString("status");
                --attemptsLeft;
            }
            if ("failure".equals(jobStatus)) {
                status.add(new ServerStatus(4, 500, "Failed to upload application bits", null));
                return this.revert(status);
            }
            appPackage.delete();
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return this.revert(status);
        }
    }

    private File getAppPackage(IFileStore appStore) throws IOException, CoreException {
        if (appStore == null) {
            return null;
        }
        if (!appStore.fetchInfo().exists()) {
            return null;
        }
        String randomName = UUID.randomUUID().toString();
        File tmp = File.createTempFile(randomName, ".zip");
        if (appStore.getName().endsWith(".war")) {
            appStore.copy((IFileStore)new LocalFile(tmp), 2, null);
            return tmp;
        }
        IFileStore[] children = appStore.childStores(0, null);
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().endsWith(".war")) {
                children[i].copy((IFileStore)new LocalFile(tmp), 2, null);
                return tmp;
            }
            ++i;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmp));
            this.writeZip(appStore, (IPath)Path.EMPTY, zos);
            zos.close();
        }
        catch (Exception exception) {
            tmp.delete();
        }
        return tmp;
    }

    private void writeZip(IFileStore source, IPath path, ZipOutputStream zos) throws IOException, CoreException {
        IFileInfo info = source.fetchInfo(0, null);
        if (info.isDirectory()) {
            IFileStore[] iFileStoreArray = source.childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                this.writeZip(child, path.append(child.getName()), zos);
                ++n2;
            }
        } else {
            ZipEntry entry = new ZipEntry(path.toString());
            zos.putNextEntry(entry);
            IOUtilities.pipe((InputStream)source.openInputStream(0, null), (OutputStream)zos, (boolean)true, (boolean)false);
        }
    }
}

