/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.handlers.v1.AppsHandlerV1;
import org.eclipse.orion.server.cf.handlers.v1.InfoHandlerV1;
import org.eclipse.orion.server.cf.handlers.v1.LogsHandlerV1;
import org.eclipse.orion.server.cf.handlers.v1.TargetHandlerV1;

public class CFHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<String> targetHandlerV1;
    private ServletResourceHandler<String> infoHandlerV1;
    private ServletResourceHandler<String> appsHandlerV1;
    private ServletResourceHandler<String> logsHandlerV1;

    public CFHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.targetHandlerV1 = new TargetHandlerV1(statusHandler);
        this.infoHandlerV1 = new InfoHandlerV1(statusHandler);
        this.appsHandlerV1 = new AppsHandlerV1(statusHandler);
        this.logsHandlerV1 = new LogsHandlerV1(statusHandler);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String jazzPathInfo) throws ServletException {
        String pathString = jazzPathInfo;
        String[] infoParts = jazzPathInfo.split("\\/", 3);
        if (infoParts.length >= 3) {
            pathString = infoParts[2];
            if (request.getContextPath().length() != 0) {
                Path path = pathString == null ? Path.EMPTY : new Path(pathString);
                Path contextPath = new Path(request.getContextPath());
                if (contextPath.isPrefixOf((IPath)path)) {
                    pathString = path.removeFirstSegments(contextPath.segmentCount()).toString();
                }
            }
        }
        if (infoParts[1].equals("target")) {
            return this.targetHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("info")) {
            return this.infoHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("apps")) {
            return this.appsHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("logs")) {
            return this.logsHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        return false;
    }
}

