/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.objects;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.orion.server.cf.objects.CFObject;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.objects.Org;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Target")
public class Target
extends CFObject {
    public static final String RESOURCE = "target";
    public static final String TYPE = "Target";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private Org org;
    private Space space;
    private Cloud cloud;

    public Target(Cloud cloud) {
        Property[] defaultProperties = new Property[]{new Property("Url"), new Property("Space"), new Property("Org")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.cloud = cloud;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return null;
    }

    @PropertyDescription(name="Url")
    public URL getUrl() {
        return this.cloud.getUrl();
    }

    public URL getManageUrl() {
        return this.cloud.getManageUrl();
    }

    public Cloud getCloud() {
        return this.cloud;
    }

    public Org getOrg() {
        return this.org;
    }

    @PropertyDescription(name="Org")
    private JSONObject getOrgJSON() {
        try {
            return this.org.toJSON();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public void setOrg(Org org) {
        this.org = org;
    }

    public Space getSpace() {
        return this.space;
    }

    @PropertyDescription(name="Space")
    private JSONObject getSpaceJSON() {
        try {
            return this.space.toJSON();
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cloud == null ? 0 : this.cloud.hashCode());
        result = 31 * result + (this.org == null ? 0 : this.org.hashCode());
        result = 31 * result + (this.space == null ? 0 : this.space.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        if (this.cloud == null ? other.cloud != null : !this.cloud.equals(other.cloud)) {
            return false;
        }
        if (this.org == null ? other.org != null : !this.org.equals(other.org)) {
            return false;
        }
        return !(this.space == null ? other.space != null : !this.space.equals(other.space));
    }
}

