/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.json.JSONException;
import org.json.JSONObject;

public class InitJob
extends GitJob {
    private final Clone clone;
    private final String user;
    private final String gitUserName;
    private final String gitUserMail;
    private String cloneLocation;

    public InitJob(Clone clone, String userRunningTask, String user, String cloneLocation, String gitUserName, String gitUserMail) {
        super(userRunningTask, true);
        this.clone = clone;
        this.user = user;
        this.gitUserName = gitUserName;
        this.gitUserMail = gitUserMail;
        this.cloneLocation = cloneLocation;
        this.setFinalMessage("Init complete.");
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    public IStatus performJob() {
        try {
            InitCommand command = new InitCommand();
            File directory = new File(this.clone.getContentLocation());
            command.setDirectory(directory);
            Repository repository = command.call().getRepository();
            Git git = new Git(repository);
            GitCloneHandlerV1.doConfigureClone(git, this.user, this.gitUserName, this.gitUserMail);
            git.commit().setMessage("Initial commit").call();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (GitAPIException e) {
            return this.getGitAPIExceptionStatus(e, "Error initializing git repository");
        }
        catch (JGitInternalException e) {
            return this.getJGitInternalExceptionStatus(e, "Error initializing git repository");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.orion.server.git", "Error initializing git repository", (Throwable)e);
        }
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put("Location", (Object)URI.create(this.cloneLocation));
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(Status.OK_STATUS, 200, jsonData);
    }
}

