/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.BaseToConfigEntryConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Config")
public class ConfigOption
extends GitObject {
    public static final String RESOURCE = "config";
    public static final String TYPE = "Config";
    private static final String EMPTY_VALUE = "";
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE_COLLECTION = new ResourceShape();
    private FileBasedConfig config;
    private String[] keySegments;

    public ConfigOption(URI cloneLocation, Repository db) throws IOException {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Key"), new Property("Value")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        Property childrenProperty = new Property("Children");
        childrenProperty.setResourceShape(DEFAULT_RESOURCE_SHAPE);
        Property[] collectionProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), childrenProperty};
        DEFAULT_RESOURCE_SHAPE_COLLECTION.setProperties(collectionProperties);
        this.config = this.getLocalConfig();
    }

    public ConfigOption(URI cloneLocation, Repository db, String key) throws IOException {
        this(cloneLocation, db);
        key = GitUtils.decode(key);
        this.keySegments = this.keyToSegments(key);
        Assert.isLegal((this.keySegments != null ? 1 : 0) != 0, (String)"Config entry key must be provided in the following form: section[.subsection].name");
    }

    private ConfigOption(URI cloneLocation, Repository db, String[] keySegments) throws IOException {
        this(cloneLocation, db);
        this.keySegments = keySegments;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        if (this.keySegments == null) {
            return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE_COLLECTION);
        }
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Children")
    private JSONArray getChildren() throws JSONException, URISyntaxException, IOException, CoreException {
        JSONArray children = new JSONArray();
        for (String section : this.config.getSections()) {
            for (String name : this.config.getNames(section)) {
                String[] stringArray = new String[3];
                stringArray[0] = section;
                stringArray[2] = name;
                children.put((Object)new ConfigOption(this.cloneLocation, this.db, stringArray).toJSON());
            }
            for (String subsection : this.config.getSubsections(section)) {
                for (String name : this.config.getNames(section, subsection)) {
                    children.put((Object)new ConfigOption(this.cloneLocation, this.db, new String[]{section, subsection, name}).toJSON());
                }
            }
        }
        return children;
    }

    @PropertyDescription(name="Key")
    private String getKey() {
        return this.segmentsToKey(this.keySegments);
    }

    @PropertyDescription(name="Value")
    private String getValue() {
        String value = this.config.getString(this.keySegments[0], this.keySegments[1], this.keySegments[2]);
        if (value == null) {
            value = EMPTY_VALUE;
        }
        return value;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        String key = this.keySegments != null ? this.segmentsToKey(this.keySegments) : EMPTY_VALUE;
        return BaseToConfigEntryConverter.CLONE.baseToConfigEntryLocation(this.cloneLocation, GitUtils.encode(key));
    }

    private FileBasedConfig getLocalConfig() throws IOException {
        if (this.db instanceof FileRepository) {
            FileRepository fr = (FileRepository)this.db;
            FileBasedConfig config = new FileBasedConfig(fr.getConfig().getFile(), FS.detect());
            try {
                config.load();
            }
            catch (ConfigInvalidException e) {
                throw new IOException(e);
            }
            return config;
        }
        throw new IllegalArgumentException("Repository is not file based.");
    }

    private String segmentsToKey(String[] segments) {
        if (segments.length == 3) {
            return segments[1] == null ? String.format("%s.%s", segments[0], segments[2]) : String.format("%s.%s.%s", segments[0], segments[1], segments[2]);
        }
        return null;
    }

    private String[] keyToSegments(String key) {
        int firstDot = key.indexOf(46);
        int lastDot = key.lastIndexOf(46);
        if (firstDot == -1 || lastDot == -1) {
            return null;
        }
        String section = key.substring(0, firstDot);
        String subsection = null;
        if (firstDot != lastDot) {
            subsection = key.substring(firstDot + 1, lastDot);
        }
        String name = key.substring(lastDot + 1);
        return new String[]{section, subsection, name};
    }

    public boolean exists() {
        if (this.keySegments[1] != null && !this.config.getNames(this.keySegments[0], this.keySegments[1]).contains(this.keySegments[2])) {
            return false;
        }
        return this.keySegments[1] != null || this.config.getNames(this.keySegments[0]).contains(this.keySegments[2]);
    }

    public FileBasedConfig getConfig() {
        return this.config;
    }

    public String getSection() {
        return this.keySegments[0];
    }

    public String getSubsection() {
        return this.keySegments[1];
    }

    public String getName() {
        return this.keySegments[2];
    }
}

