/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.useradmin.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.useradmin.UserAdminActivator;

public class UserAuthFilter
implements Filter {
    private IAuthenticationService authenticationService;
    private Properties authProperties;
    private List<String> authorizedAccountCreators;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authenticationService = UserAdminActivator.getDefault().getAuthenticationService();
        if (this.authenticationService == null) {
            String msg = "Authentication service is missing. The server configuration must specify an authentication scheme, or use \"None\" to indicate no authentication";
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core.useradmin", msg, null));
            throw new ServletException(msg);
        }
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            this.authorizedAccountCreators = new ArrayList<String>();
            this.authorizedAccountCreators.addAll(Arrays.asList(creators.split(",")));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equals(httpRequest.getMethod()) && httpRequest.getParameter("reset") == null && (this.authorizedAccountCreators == null || this.authorizedAccountCreators.contains(httpRequest.getRemoteUser()))) {
            chain.doFilter(request, response);
            return;
        }
        String login = httpRequest.getRemoteUser();
        if (login == null && (login = this.authenticationService.getAuthenticatedUser(httpRequest, httpResponse, this.authProperties)) == null) {
            return;
        }
        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)login);
        request.setAttribute("org.osgi.service.http.authentication.type", (Object)this.authenticationService.getAuthType());
        try {
            String requestPath = String.valueOf(httpRequest.getServletPath()) + (httpRequest.getPathInfo() == null ? "" : httpRequest.getPathInfo());
            if (!AuthorizationService.checkRights((String)login, (String)requestPath, (String)httpRequest.getMethod())) {
                httpResponse.sendError(403);
                return;
            }
        }
        catch (CoreException coreException) {
            httpResponse.sendError(500);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

