/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCommand
implements ICFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Login";
    private Target target;
    private String username;
    private String password;
    private JSONObject accessToken;

    public LoginCommand(Target target, String username, String password) {
        this.target = target;
        this.username = username;
        this.password = password;
    }

    @Override
    public IStatus doIt() {
        try {
            URI infoURI = URIUtil.toURI((URL)this.target.getUrl());
            infoURI = infoURI.resolve("/v2/info");
            GetMethod getMethod = new GetMethod(infoURI.toString());
            getMethod.addRequestHeader(new Header("Accept", "application/json"));
            getMethod.addRequestHeader(new Header("Content-Type", "application/json"));
            CFActivator.getDefault().getHttpClient().executeMethod((HttpMethod)getMethod);
            String response = getMethod.getResponseBodyAsString();
            JSONObject result = new JSONObject(response);
            String authorizationEndpoint = result.getString("authorization_endpoint");
            URI loginURI = new URI(authorizationEndpoint);
            loginURI = URIUtil.append((URI)loginURI, (String)"/oauth/token");
            PostMethod postMethod = new PostMethod(loginURI.toString());
            postMethod.addRequestHeader(new Header("Accept", "application/json"));
            postMethod.addRequestHeader(new Header("Content-Type", "application/x-www-form-urlencoded"));
            postMethod.addRequestHeader(new Header("Authorization", "Basic Y2Y6"));
            postMethod.addParameter("grant_type", "password");
            postMethod.addParameter("password", this.password);
            postMethod.addParameter("username", this.username);
            postMethod.addParameter("scope", "");
            int code = CFActivator.getDefault().getHttpClient().executeMethod((HttpMethod)postMethod);
            response = postMethod.getResponseBodyAsString();
            if (code != 200) {
                try {
                    result = new JSONObject(response);
                    return new ServerStatus(4, code, "", result, null);
                }
                catch (Exception exception) {
                    result = null;
                    return new ServerStatus(4, code, "Unexpected error", null);
                }
            }
            this.target.getCloud().setAccessToken(new JSONObject(response));
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new Status(4, "org.eclipse.orion.server.cf", msg, (Throwable)e);
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    public JSONObject getOAuthAccessToken() {
        return this.accessToken;
    }
}

