/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.useradmin.simple;

import org.eclipse.orion.internal.server.useradmin.simple.SimpleUserCredentialsService;
import org.eclipse.orion.internal.server.useradmin.simple.SimpleUserProfileService;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.orion.server.useradmin.IOrionCredentialsService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String PI_USER_SIMPLE = "org.eclipse.orion.server.useradmin.simple";
    private ServiceRegistration<IOrionCredentialsService> userCredentialsService;
    private ServiceRegistration<IOrionUserProfileService> userProfileService;
    public static Activator singleton;

    public static Activator getDefault() {
        return singleton;
    }

    public void start(BundleContext bundleContext) throws Exception {
        singleton = this;
        String metastore = OrionConfiguration.getMetaStorePreference();
        if ("simple".equals(metastore)) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            this.userCredentialsService = bundleContext.registerService(IOrionCredentialsService.class, (Object)new SimpleUserCredentialsService(), null);
            logger.debug("Started simple user credentials service.");
            this.userProfileService = bundleContext.registerService(IOrionUserProfileService.class, (Object)new SimpleUserProfileService(), null);
            logger.debug("Started simple user profile service.");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.userCredentialsService != null) {
            this.userCredentialsService.unregister();
        }
        if (this.userProfileService != null) {
            this.userProfileService.unregister();
        }
    }
}

