/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.SiteConfiguration;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.eclipse.orion.server.core.users.OrionScope;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;

class WebUser
extends WebElement {
    private static final Base64Counter userCounter = new Base64Counter();
    static final String USERS_NODE = "Users";

    public WebUser(IEclipsePreferences store) {
        super(store);
    }

    private static IEclipsePreferences getUserNode(String uid) {
        try {
            return (IEclipsePreferences)new OrionScope().getNode(USERS_NODE).node(uid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean exists(String userId) {
        if (userId == null) {
            return false;
        }
        try {
            return scope.getNode(USERS_NODE).nodeExists(userId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static synchronized String nextUserId() {
        while (WebUser.exists(userCounter.toString())) {
            userCounter.increment();
        }
        return userCounter.toString();
    }

    public static WebUser fromUserId(String userId) {
        IEclipsePreferences result = WebUser.getUserNode(userId);
        if (result.get("Name", null) == null) {
            result.put("Name", "Unnamed User");
        }
        result.put("Id", userId);
        if (result.get("UserName", null) == null) {
            result.put("UserName", userId);
        }
        WebUser user = new WebUser(result);
        try {
            user.save();
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return user;
    }

    public WebWorkspace createWorkspace(String name) throws CoreException {
        String id = WebWorkspace.nextWorkspaceId(this.getUserName());
        WebWorkspace workspace = WebWorkspace.fromId(id);
        workspace.setName(name);
        workspace.save();
        JSONObject newWorkspace = new JSONObject();
        try {
            newWorkspace.put("Id", (Object)id);
            newWorkspace.put("LastModified", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {}
        String workspaces = this.store.get("Workspaces", null);
        JSONArray workspaceArray = null;
        if (workspaces != null) {
            try {
                workspaceArray = new JSONArray(workspaces);
            }
            catch (JSONException jSONException) {}
        }
        if (workspaceArray == null) {
            workspaceArray = new JSONArray();
        }
        workspaceArray.put((Object)newWorkspace);
        this.store.put("Workspaces", workspaceArray.toString());
        this.save();
        return workspace;
    }

    public JSONArray getWorkspacesJSON() {
        try {
            String workspaces = this.store.get("Workspaces", null);
            if (workspaces != null) {
                return new JSONArray(workspaces);
            }
        }
        catch (JSONException jSONException) {}
        return new JSONArray();
    }

    public String getUserName() {
        return this.store.get("UserName", "");
    }

    public void setUserName(String name) {
        this.store.put("UserName", name);
    }

    public SiteConfiguration createSiteConfiguration(String id, String name, String workspace) throws CoreException {
        SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
        siteConfig.setName(name);
        siteConfig.setWorkspace(workspace);
        siteConfig.save();
        JSONObject newSiteConfiguration = new JSONObject();
        try {
            newSiteConfiguration.put("Id", (Object)id);
        }
        catch (JSONException jSONException) {}
        IEclipsePreferences siteConfigNode = (IEclipsePreferences)this.getSiteConfigurationsNode().node(id);
        siteConfigNode.put("Id", id);
        this.save();
        return siteConfig;
    }

    public void removeSiteConfiguration(SiteConfiguration siteConfig) throws CoreException {
        try {
            this.getSiteConfigurationsNode().node(siteConfig.getId()).removeNode();
            siteConfig.delete();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error removing site configuration", (Throwable)e));
        }
        this.save();
    }

    public JSONArray getSiteConfigurationsJSON(URI baseLocation) {
        try {
            IEclipsePreferences siteConfigsNode = (IEclipsePreferences)this.store.node("SiteConfigurations");
            String[] siteConfigIds = siteConfigsNode.childrenNames();
            JSONArray jsonArray = new JSONArray();
            String[] stringArray = siteConfigIds;
            int n = siteConfigIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                SiteConfiguration siteConfig = WebUser.getExistingSiteConfiguration(id);
                if (siteConfig != null) {
                    JSONObject siteConfigJson = SiteConfiguration.toJSON(siteConfig, baseLocation);
                    jsonArray.put((Object)siteConfigJson);
                }
                ++n2;
            }
            return jsonArray;
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
            return new JSONArray();
        }
    }

    public SiteConfiguration getSiteConfiguration(String id) {
        try {
            IEclipsePreferences siteConfigsNode = this.getSiteConfigurationsNode();
            if (siteConfigsNode.nodeExists(id)) {
                if (SiteConfiguration.siteConfigExists(id)) {
                    SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
                    return siteConfig;
                }
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Site configuration does not exist in backing store"));
            }
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        return null;
    }

    private static SiteConfiguration getExistingSiteConfiguration(String id) {
        if (SiteConfiguration.siteConfigExists(id)) {
            SiteConfiguration siteConfig = SiteConfiguration.fromId(id);
            return siteConfig;
        }
        return null;
    }

    private IEclipsePreferences getSiteConfigurationsNode() {
        return (IEclipsePreferences)this.store.node("SiteConfigurations");
    }

    public void delete() throws CoreException {
        try {
            IEclipsePreferences parent = (IEclipsePreferences)this.store.parent();
            this.store.clear();
            this.store.removeNode();
            parent.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error removing user", (Throwable)e));
        }
    }

    public void deleteWorkspace(String workspaceId) throws CoreException {
        String workspaces = this.store.get("Workspaces", null);
        JSONArray workspaceArray = null;
        if (workspaces != null) {
            try {
                workspaceArray = new JSONArray(workspaces);
            }
            catch (JSONException jSONException) {}
        }
        if (workspaceArray == null) {
            workspaceArray = new JSONArray();
        }
        int i = 0;
        while (i < workspaceArray.length()) {
            String workspace = null;
            try {
                String jsonString = workspaceArray.getString(i);
                JSONObject jsonObject = new JSONObject(jsonString);
                workspace = jsonObject.getString("Id");
            }
            catch (JSONException jSONException) {}
            if (workspaceId.equals(workspace)) {
                workspaceArray.remove(i);
            }
            ++i;
        }
        this.store.put("Workspaces", workspaceArray.toString());
        this.save();
    }
}

