/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.npm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.npm.ProcessController;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;

public class NpmServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        super.init();
    }

    public void destroy() {
        super.destroy();
    }

    private String excuteCmd(String type, String cwd, String args) {
        String result = "";
        try {
            IPath path = new Path(cwd).removeFirstSegments(1);
            IFileStore fStore = NewFileServlet.getFileStore(null, (IPath)path);
            if (fStore == null) {
                result = "Error: This command must be used in an application folder\n";
                return result;
            }
            String cwdPath = fStore.toString();
            String npmPath = PreferenceHelper.getString((String)"orion.npmPath");
            if (npmPath == null || npmPath.isEmpty()) {
                result = "Error: Npm path is not defined, contact the server administrator.\n";
                return result;
            }
            String[] cmd = args != null ? new String[]{npmPath, type, args} : new String[]{npmPath, type};
            ProcessController pc = new ProcessController(295000L, cmd, new File(cwdPath));
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            ByteArrayOutputStream errs = new ByteArrayOutputStream();
            pc.forwardOutput(outs);
            pc.forwardErrorOutput(errs);
            pc.execute();
            String cmdOutPut = new String(outs.toByteArray(), "UTF-8");
            String cmdError = new String(errs.toByteArray(), "UTF-8");
            result = String.valueOf(result) + cmdError + cmdOutPut;
        }
        catch (Exception err) {
            return err.getMessage();
        }
        return result;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            JSONObject o = OrionServlet.readJSONRequest((HttpServletRequest)req);
            String type = o.getString("type");
            String cwd = o.getString("cwd");
            cwd = new URI(cwd).getPath();
            String args = null;
            if (type.equalsIgnoreCase("install") && (args = o.getString("package")).equalsIgnoreCase("null")) {
                args = null;
            }
            String result = this.excuteCmd(type, cwd, args);
            resp.setStatus(200);
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("cmdOutput", (Object)result);
            OrionServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)jsonResult);
        }
        catch (JSONException e) {
            resp.sendError(500, e.getMessage());
        }
        catch (IOException e) {
            resp.sendError(500, e.getMessage());
        }
        catch (URISyntaxException e) {
            resp.sendError(500, e.getMessage());
        }
    }
}

