/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.internal.server.core.Activator;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.json.JSONObject;

public class GitUtils {
    private static Set<String> uriSchemeWhitelist = new HashSet<String>(Arrays.asList("ftp", "git", "http", "https", "sftp", "ssh"));
    private static Method SET_SSO_METHOD;
    private static boolean SET_SSO_METHOD_INITIALIZED;
    private static final RefSpec FORCE_INITIALIZE;
    private static Method GET_SSO_METHOD;
    private static boolean GET_SSO_METHOD_INITIALIZED;

    static {
        FORCE_INITIALIZE = Transport.REFSPEC_TAGS;
    }

    public static File getGitDir(IPath path) throws CoreException {
        Map<IPath, File> gitDirs = GitUtils.getGitDirs(path, Traverse.GO_UP);
        if (gitDirs == null) {
            return null;
        }
        Collection<File> values = gitDirs.values();
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray(new File[0])[0];
    }

    public static File getGitDir(File file) {
        if (file.exists()) {
            while (file != null) {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    return file;
                }
                if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                    return new File(file, ".git");
                }
                file = file.getParentFile();
            }
        }
        return null;
    }

    public static Map<IPath, File> getGitDirs(IPath path, Traverse traverse) throws CoreException {
        IPath p = path.removeFirstSegments(1);
        IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)p);
        if (fileStore == null) {
            return null;
        }
        HashMap<IPath, File> result = new HashMap<IPath, File>();
        File file = fileStore.toLocalFile(0, null);
        if (file == null) {
            return result;
        }
        switch (traverse) {
            case CURRENT: {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    result.put((IPath)new Path(""), file);
                    break;
                }
                if (!RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) break;
                result.put((IPath)new Path(""), new File(file, ".git"));
                break;
            }
            case GO_UP: {
                GitUtils.getGitDirsInParents(file, result);
                break;
            }
            case GO_DOWN: {
                GitUtils.getGitDirsInChildren(file, p, result);
            }
        }
        return result;
    }

    private static void getGitDirsInParents(File file, Map<IPath, File> gitDirs) {
        int levelUp = 0;
        File workspaceRoot = Activator.getDefault().getPlatformLocation().toFile();
        while (file != null && !file.getAbsolutePath().equals(workspaceRoot.getAbsolutePath())) {
            if (file.exists()) {
                if (RepositoryCache.FileKey.isGitRepository((File)file, (FS)FS.DETECTED)) {
                    gitDirs.put(GitUtils.getPathForLevelUp(levelUp), file);
                    return;
                }
                if (RepositoryCache.FileKey.isGitRepository((File)new File(file, ".git"), (FS)FS.DETECTED)) {
                    gitDirs.put(GitUtils.getPathForLevelUp(levelUp), new File(file, ".git"));
                    return;
                }
            }
            file = file.getParentFile();
            ++levelUp;
        }
    }

    private static IPath getPathForLevelUp(int levelUp) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < levelUp) {
            sb.append("../");
            ++i;
        }
        return new Path(sb.toString());
    }

    private static void getGitDirsInChildren(File localFile, IPath path, Map<IPath, File> gitDirs) throws CoreException {
        if (localFile.exists() && localFile.isDirectory()) {
            File[] folders;
            if (RepositoryCache.FileKey.isGitRepository((File)localFile, (FS)FS.DETECTED)) {
                gitDirs.put(path.addTrailingSeparator(), localFile);
                return;
            }
            if (RepositoryCache.FileKey.isGitRepository((File)new File(localFile, ".git"), (FS)FS.DETECTED)) {
                gitDirs.put(path.addTrailingSeparator(), new File(localFile, ".git"));
                return;
            }
            File[] fileArray = folders = localFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(".git");
                }
            });
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                GitUtils.getGitDirsInChildren(folder, path.append(folder.getName()), gitDirs);
                ++n2;
            }
            return;
        }
    }

    public static String getRelativePath(IPath filePath, IPath pathToGitRoot) {
        StringBuilder sb = new StringBuilder();
        String file = null;
        if (!filePath.hasTrailingSeparator()) {
            file = filePath.lastSegment();
            filePath = filePath.removeLastSegments(1);
        }
        int i = 0;
        while (i < pathToGitRoot.segments().length) {
            if (pathToGitRoot.segments()[i].equals("..")) {
                sb.append(filePath.segment(filePath.segments().length - pathToGitRoot.segments().length + i)).append("/");
            }
            ++i;
        }
        if (file != null) {
            sb.append(file);
        }
        return sb.toString();
    }

    static GitCredentialsProvider createGitCredentialsProvider(JSONObject json) {
        String username = json.optString("GitSshUsername", null);
        char[] password = json.optString("GitSshPassword", "").toCharArray();
        String knownHosts = json.optString("GitSshKnownHost", null);
        byte[] privateKey = json.optString("GitSshPrivateKey", "").getBytes();
        byte[] publicKey = json.optString("GitSshPublicKey", "").getBytes();
        byte[] passphrase = json.optString("GitSshPassphrase", "").getBytes();
        GitCredentialsProvider cp = new GitCredentialsProvider(null, username, password, knownHosts);
        cp.setPrivateKey(privateKey);
        cp.setPublicKey(publicKey);
        cp.setPassphrase(passphrase);
        return cp;
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static ProjectInfo projectFromPath(IPath path) {
        if (path == null || path.segmentCount() < 3) {
            return null;
        }
        String workspaceId = path.segment(1);
        String projectName = path.segment(2);
        try {
            return OrionConfiguration.getMetaStore().readProject(workspaceId, projectName);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IPath pathFromProject(WorkspaceInfo workspace, ProjectInfo project) {
        return new Path("/file").append(workspace.getUniqueId()).append(project.getFullName());
    }

    public static boolean isForbiddenGitUri(URIish uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        String path = uri.getPath();
        boolean isForbidden = false;
        isForbidden = scheme != null ? !uriSchemeWhitelist.contains(scheme) : (host != null ? host.length() == 1 || path == null : true);
        return isForbidden;
    }

    public static boolean isGerrit(Config config) {
        return config.getBoolean("gerrit", "createchangeid", false);
    }

    public static void _testAllowFileScheme(boolean allow) {
        if (allow) {
            uriSchemeWhitelist.add("file");
        } else {
            uriSchemeWhitelist.remove("file");
        }
    }

    public static void setSSOToken(Cookie c) {
        if (SET_SSO_METHOD == null && !SET_SSO_METHOD_INITIALIZED) {
            try {
                SET_SSO_METHOD_INITIALIZED = true;
                SET_SSO_METHOD = TransportHttp.class.getMethod("setSSOToken", Cookie.class);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (SET_SSO_METHOD != null) {
            try {
                SET_SSO_METHOD.invoke(null, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public static Cookie getSSOToken() {
        if (GET_SSO_METHOD == null && !GET_SSO_METHOD_INITIALIZED) {
            try {
                GET_SSO_METHOD_INITIALIZED = true;
                GET_SSO_METHOD = TransportHttp.class.getMethod("getSSOToken", new Class[0]);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (GET_SSO_METHOD != null) {
            try {
                return (Cookie)GET_SSO_METHOD.invoke(null, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }

    public static enum Traverse {
        GO_UP,
        GO_DOWN,
        CURRENT;

    }
}

