/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.task;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.ITaskService;
import org.eclipse.orion.server.core.tasks.TaskDoesNotExistException;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.core.tasks.TaskOperationException;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    public static final int LONGPOLLING_WAIT_TIME = 60000;
    public static final String KEY_RUNNING_ONLY = "RunningOnly";
    ServiceTracker<ITaskService, ITaskService> taskTracker;

    public TaskServlet() {
        this.initTaskService();
    }

    private void initTaskService() {
        this.taskTracker = new ServiceTracker(Activator.bundleContext, ITaskService.class, null);
        this.taskTracker.open();
    }

    @Override
    protected void handleException(HttpServletResponse resp, String msg, Exception e) throws ServletException {
        super.handleException(resp, msg, e);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path2 = path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        if (path.segmentCount() != 2) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        try {
            JSONObject data = OrionServlet.readJSONRequest(req);
            if (!"true".equals(data.getString(TaskInfo.TaskStatus.ABORT.toString()))) {
                this.handleException(resp, "Invalid request paramethers, try {" + TaskInfo.TaskStatus.ABORT.toString() + ":true}", null, 400);
            }
        }
        catch (JSONException e1) {
            this.handleException(resp, "Invalid request paramethers, try {" + TaskInfo.TaskStatus.ABORT.toString() + ":true}", (Exception)((Object)e1), 400);
        }
        boolean isKeep = "id".equals(path.segment(0));
        String taskId = path.segment(1);
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        try {
            taskService.cancelTask(TaskJobHandler.getUserId(req), taskId, isKeep);
        }
        catch (TaskDoesNotExistException e) {
            this.handleException(resp, "Could not cancel task that does not exist: " + e.getTaskId(), (Exception)((Object)e), 404);
            return;
        }
        catch (TaskOperationException e) {
            this.handleException(resp, e.getMessage(), (Exception)((Object)e));
            return;
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        if (path.segmentCount() == 0) {
            taskService.removeCompletedTasks(TaskJobHandler.getUserId(req));
            List tasks = taskService.getTasks(TaskJobHandler.getUserId(req));
            ArrayList<String> locations = new ArrayList<String>();
            try {
                for (TaskInfo task : tasks) {
                    locations.add(TaskServlet.getJsonWithLocation(req, task).optString("Location"));
                }
            }
            catch (Exception e) {
                this.handleException(resp, e.getMessage(), e);
            }
            TaskServlet.writeJSONResponse(req, resp, new JSONArray(locations));
            return;
        }
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0)) && !"temp".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        boolean isKeep = "id".equals(path.segment(0));
        String taskId = path.segment(1);
        try {
            taskService.removeTask(TaskJobHandler.getUserId(req), taskId, isKeep);
        }
        catch (TaskDoesNotExistException e) {
            this.handleException(resp, "Could not remove task that does not exist: " + e.getTaskId(), (Exception)((Object)e), 404);
            return;
        }
        catch (TaskOperationException e) {
            this.handleException(resp, e.getMessage(), (Exception)((Object)e));
            return;
        }
    }

    public JSONObject getTasksList(Collection<TaskInfo> tasks, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, URISyntaxException {
        return this.getTasksList(tasks, new ArrayList<String>(), req, resp);
    }

    private static JSONObject getJsonWithLocation(HttpServletRequest req, TaskInfo task) throws JSONException, URISyntaxException {
        return TaskServlet.getJsonWithLocation(req, task, true);
    }

    private static JSONObject getJsonWithLocation(HttpServletRequest req, TaskInfo task, boolean includeResult) throws JSONException, URISyntaxException {
        JSONObject taskJson;
        JSONObject jSONObject = taskJson = includeResult ? task.toJSON() : task.toLightJSON();
        if (taskJson.optString("Location", "").equals("")) {
            URI uri = ServletResourceHandler.getURI(req);
            if (task.isKeep()) {
                taskJson.put("Location", (Object)new URI(uri.getScheme(), null, "/task/id/" + task.getId(), null, null));
            } else {
                taskJson.put("Location", (Object)new URI(uri.getScheme(), null, "/task/temp/" + task.getId(), null, null));
            }
        }
        return taskJson;
    }

    public JSONObject getTasksList(Collection<TaskInfo> tasks, Collection<String> deletedTasks, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONException, URISyntaxException {
        JSONObject result = new JSONObject();
        JSONArray tasksList = new JSONArray();
        for (TaskInfo task : tasks) {
            tasksList.put((Object)TaskServlet.getJsonWithLocation(req, task, "true".equals(req.getParameter("results"))));
        }
        result.put("DeletedChildren", deletedTasks);
        result.put("Children", (Object)tasksList);
        return result;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        Path path = pathInfo == null ? Path.EMPTY : new Path(pathInfo);
        ITaskService taskService = (ITaskService)this.taskTracker.getService();
        if (path.segmentCount() == 0) {
            List tasks = taskService.getTasks(TaskJobHandler.getUserId(req));
            try {
                TaskServlet.writeJSONResponse(req, resp, this.getTasksList(tasks, req, resp));
            }
            catch (JSONException e) {
                this.handleException(resp, e.getMessage(), (Exception)((Object)e));
                return;
            }
            catch (URISyntaxException e) {
                this.handleException(resp, e.getMessage(), e);
                return;
            }
            return;
        }
        if (path.segmentCount() != 2 || !"id".equals(path.segment(0)) && !"temp".equals(path.segment(0))) {
            this.handleException(resp, "Invalid request path: " + path, null, 400);
            return;
        }
        if (taskService == null) {
            this.handleException(resp, "Task service is unavailable", null);
            return;
        }
        String taskId = path.segment(1);
        boolean keep = "id".equals(path.segment(0));
        TaskInfo task = taskService.getTask(TaskJobHandler.getUserId(req), taskId, keep);
        if (task == null) {
            JSONObject errorDescription = new JSONObject();
            try {
                errorDescription.put("taskNotFound", (Object)taskId);
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, "Task not found: " + taskId, errorDescription, null));
            }
            catch (JSONException e) {
                this.handleException(resp, e.getMessage(), (Exception)((Object)e));
            }
            return;
        }
        JSONObject result = task.toJSON();
        if (task.isKeep()) {
            try {
                if (result.optString("Location", "").equals("")) {
                    result.put("Location", (Object)ServletResourceHandler.getURI(req));
                }
            }
            catch (JSONException e) {
                this.handleException(resp, e.getMessage(), (Exception)((Object)e));
            }
        }
        TaskServlet.writeJSONResponse(req, resp, result);
    }

    public static void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, Object result) throws IOException {
        JSONObject jsonResult;
        if (result instanceof JSONObject && (jsonResult = (JSONObject)result).optBoolean("LocationOnly")) {
            TaskServlet.writeJSONResponse(req, resp, result, JsonURIUnqualificationStrategy.LOCATION_ONLY);
            return;
        }
        TaskServlet.writeJSONResponse(req, resp, result, JsonURIUnqualificationStrategy.ALL);
    }
}

