/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;

class SiteConfiguration
extends WebElement {
    public static final String SITE_CONFIGURATIONS_NODE_NAME = "SiteConfigurations";

    public static JSONObject toJSON(SiteConfiguration site, URI baseLocation) {
        JSONObject result = new JSONObject();
        try {
            result.put("Id", (Object)site.getId());
            result.put("Name", (Object)site.getName());
        }
        catch (JSONException jSONException) {}
        try {
            if (baseLocation != null) {
                result.put("Location", (Object)URIUtil.append((URI)baseLocation, (String)site.getId()));
            }
            result.putOpt("HostHint", (Object)site.getHostHint());
            result.putOpt("Workspace", (Object)site.getWorkspace());
            result.put("Mappings", (Object)site.getMappingsJSON());
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public SiteConfiguration(IEclipsePreferences store) {
        super(store);
    }

    public static SiteConfiguration fromId(String id) {
        SiteConfiguration siteConfiguration = new SiteConfiguration((IEclipsePreferences)scope.getNode(SITE_CONFIGURATIONS_NODE_NAME).node(id));
        siteConfiguration.setId(id);
        return siteConfiguration;
    }

    public static boolean siteConfigExists(String id) {
        try {
            return scope.getNode(SITE_CONFIGURATIONS_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void delete() throws CoreException {
        try {
            IEclipsePreferences parent = (IEclipsePreferences)this.store.parent();
            this.store.removeNode();
            parent.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", "Error saving state"));
        }
    }

    public String getHostHint() {
        return this.store.get("HostHint", null);
    }

    public String getWorkspace() {
        return this.store.get("Workspace", null);
    }

    public JSONArray getMappingsJSON() {
        try {
            return new JSONArray(this.store.get("Mappings", "[]"));
        }
        catch (JSONException jSONException) {
            return new JSONArray();
        }
    }

    public void setHostHint(String hostHint) {
        this.store.put("HostHint", hostHint);
    }

    public void setWorkspace(String workspace) {
        this.store.put("Workspace", workspace);
    }

    public void setMappings(JSONArray mappings) {
        this.store.put("Mappings", mappings.toString());
    }

    public void update(SiteInfo siteInfo) throws CoreException {
        this.setId(siteInfo.getId());
        this.setName(siteInfo.getName());
        this.setHostHint(siteInfo.getHostHint());
        this.setMappings(siteInfo.getMappingsJSON());
        this.setWorkspace(siteInfo.getWorkspace());
        this.save();
    }
}

