/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class PreferencesServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        MetadataInfo node = this.getNode(req, resp);
        if (node == null) {
            return;
        }
        String key = req.getParameter("key");
        try {
            String prefix = this.getPrefix(req);
            JSONObject result = null;
            if (key != null) {
                String value = node.getProperty((prefix = String.valueOf(prefix) + '/' + key).toString());
                if (value == null) {
                    this.handleNotFound(req, resp, 404);
                    return;
                }
                result = new JSONObject().put(key, (Object)value);
            } else {
                result = this.toJSON(req, prefix.toString(), node);
                if (result.length() == 0) {
                    this.handleNotFound(req, resp, 404);
                    return;
                }
            }
            PreferencesServlet.writeJSONResponse(req, resp, result);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to retrieve preferences for path {0}", (Object)req.getPathInfo()), e);
            return;
        }
    }

    private String getPrefix(HttpServletRequest req) {
        Path path;
        String scope;
        String pathString = req.getPathInfo();
        if (pathString == null) {
            pathString = "";
        }
        if ("user".equalsIgnoreCase(scope = (path = new Path(pathString)).segment(0))) {
            path = path.removeFirstSegments(1);
        } else if ("workspace".equalsIgnoreCase(scope)) {
            path = path.removeFirstSegments(2);
        } else if ("project".equalsIgnoreCase(scope)) {
            path = path.removeFirstSegments(3);
        }
        return path.toString();
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        MetadataInfo info = this.getNode(req, resp);
        if (info == null) {
            resp.setStatus(204);
            return;
        }
        String key = req.getParameter("key");
        try {
            String prefix = this.getPrefix(req);
            boolean changed = false;
            if (key != null) {
                changed = info.setProperty((prefix = String.valueOf(prefix) + '/' + key).toString(), null) != null;
            } else {
                if (prefix.startsWith("user/")) {
                    resp.setStatus(403);
                    return;
                }
                changed = this.removeMatchingProperties(info, prefix.toString());
            }
            if (changed) {
                this.save(info);
            }
            resp.setStatus(204);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to retrieve preferences for path {0}", (Object)req.getPathInfo()), e);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataInfo getNode(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String pathString = req.getPathInfo();
        if (pathString == null) {
            pathString = "";
        }
        Path path = new Path(pathString);
        int segmentCount = path.segmentCount();
        String scope = path.segment(0);
        try {
            if ("user".equalsIgnoreCase(scope)) {
                String username = req.getRemoteUser();
                if (username == null) {
                    resp.setStatus(403);
                    return null;
                }
                return OrionConfiguration.getMetaStore().readUser(username);
            }
            if ("workspace".equalsIgnoreCase(scope) && segmentCount > 1) {
                return OrionConfiguration.getMetaStore().readWorkspace(path.segment(1));
            }
            if ("project".equalsIgnoreCase(scope) && segmentCount > 2) {
                return OrionConfiguration.getMetaStore().readProject(path.segment(1), path.segment(2));
            }
        }
        catch (CoreException e) {
            this.handleException(resp, "Internal error obtaining preferences", (Exception)((Object)e), 500);
            return null;
        }
        this.handleNotFound(req, resp, 405);
        return null;
    }

    private void handleNotFound(HttpServletRequest req, HttpServletResponse resp, int code) throws ServletException {
        String path = req.getPathInfo() == null ? "/" : req.getPathInfo();
        String msg = code == 404 ? "No preferences found for path {0}" : "Invalid preference path {0}";
        this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", NLS.bind((String)msg, (Object)path)), code);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        MetadataInfo info = this.getNode(req, resp);
        if (info == null) {
            return;
        }
        String key = req.getParameter("key");
        String prefix = this.getPrefix(req);
        try {
            boolean changed = false;
            if (key != null) {
                String oldValue;
                prefix = String.valueOf(prefix) + '/' + key;
                String newValue = req.getParameter("value");
                changed = !newValue.equals(oldValue = info.setProperty(prefix.toString(), newValue));
            } else {
                JSONObject newNode = new JSONObject(new JSONTokener((Reader)req.getReader()));
                if (prefix.startsWith("user/")) {
                    resp.setStatus(403);
                    return;
                }
                if (!prefix.equals("operations")) {
                    changed |= this.removeMatchingProperties(info, prefix.toString());
                }
                Iterator it = newNode.keys();
                while (it.hasNext()) {
                    String qualifiedKey;
                    String oldValue;
                    key = (String)it.next();
                    String newValue = newNode.getString(key);
                    changed |= !newValue.equals(oldValue = info.setProperty(qualifiedKey = String.valueOf(prefix) + '/' + key, newValue));
                }
            }
            if (changed) {
                this.save(info);
            }
            resp.setStatus(204);
        }
        catch (Exception e) {
            this.handleException(resp, NLS.bind((String)"Failed to store preferences for {0}", (Object)req.getRequestURL()), e);
            return;
        }
    }

    private void save(MetadataInfo info) throws CoreException {
        IMetaStore store = OrionConfiguration.getMetaStore();
        if (info instanceof UserInfo) {
            store.updateUser((UserInfo)info);
        } else if (info instanceof WorkspaceInfo) {
            store.updateWorkspace((WorkspaceInfo)info);
        } else if (info instanceof ProjectInfo) {
            store.updateProject((ProjectInfo)info);
        }
    }

    private boolean removeMatchingProperties(MetadataInfo info, String prefix) {
        Map properties = info.getProperties();
        boolean changed = false;
        Set keySet = properties.keySet();
        String[] stringArray = keySet.toArray(new String[keySet.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String previous;
            String key = stringArray[n2];
            if (key.startsWith(prefix) && (previous = info.setProperty(key, null)) != null) {
                changed = true;
            }
            ++n2;
        }
        return changed;
    }

    private JSONObject toJSON(HttpServletRequest req, String prefix, MetadataInfo info) throws JSONException {
        JSONObject result = new JSONObject();
        Map properties = info.getProperties();
        for (String key : properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length() + 1), PreferencesServlet.stringToJSON((String)properties.get(key)));
        }
        return result;
    }

    private static Object stringToJSON(String input) {
        if (input == null) {
            return null;
        }
        Object result = null;
        if (input.startsWith("{")) {
            try {
                result = new JSONObject(input);
            }
            catch (JSONException jSONException) {}
        } else if (input.startsWith("[")) {
            try {
                result = new JSONArray(input);
            }
            catch (JSONException jSONException) {}
        }
        if (result == null) {
            result = JSONObject.stringToValue((String)input);
        }
        return result;
    }
}

