/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.docker.server;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class DockerWebSocket {
    private CountDownLatch messageLatch;
    private String response;
    private Session session;

    public String getResponse() {
        return this.response;
    }

    public Session getSession() {
        return this.session;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
        if (logger.isDebugEnabled()) {
            JSONObject jsonObject = new JSONObject();
            String received = msg;
            try {
                jsonObject.put("message", (Object)msg);
                received = jsonObject.toString();
            }
            catch (JSONException jSONException) {}
            logger.debug("Docker Socket received: " + received);
        }
        this.response = String.valueOf(this.response) + msg;
        if (this.messageLatch != null) {
            this.messageLatch.countDown();
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
        if (logger.isDebugEnabled()) {
            logger.debug("Docker Socket closed" + (statusCode != 1000 ? ": " + reason : ""));
        }
        this.session.close();
    }

    public void send(String msg) {
        block5: {
            try {
                if (!this.session.isOpen()) {
                    return;
                }
                this.messageLatch = new CountDownLatch(1);
                this.response = "";
                this.session.getRemote().sendString(msg);
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
                if (!logger.isDebugEnabled()) break block5;
                JSONObject jsonObject = new JSONObject();
                String sent = msg;
                try {
                    jsonObject.put("message", (Object)msg);
                    sent = jsonObject.toString();
                }
                catch (JSONException jSONException) {}
                logger.debug("Docker Socket sent: " + sent);
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.servlets.OrionServlet");
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                this.session.close();
            }
        }
    }

    public boolean waitResponse() throws InterruptedException {
        return this.messageLatch.await(5L, TimeUnit.SECONDS);
    }
}

