/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.ManifestNode;
import org.eclipse.orion.server.cf.manifest.ManifestParser;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManifest_Command
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private App application;
    private IFileStore fileStore;

    public ParseManifest_Command(Target target, App app, IFileStore fileStore) {
        super(target);
        this.application = app;
        this.fileStore = fileStore;
        this.commandName = NLS.bind((String)"Parse application manifest: {0}", (Object)fileStore.toURI());
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            IFileStore manifestStore = this.fileStore.getChild("manifest.yml");
            if (!manifestStore.fetchInfo().exists()) {
                String msg = "Failed to find application manifest. If you have one, please select it or the folder that contains it before deploying.";
                return new ServerStatus(4, 400, msg, null);
            }
            Scanner manifestScanner = new Scanner(manifestStore.openInputStream(0, null));
            ManifestNode manifestTree = ManifestParser.parse(manifestScanner);
            manifestScanner.close();
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            JSONObject manifest = manifestTree.toJSON(targetURI);
            JSONObject appJSON = ManifestUtils.getApplication(manifest);
            String path = appJSON.optString("path");
            if (path.isEmpty()) {
                path = ".";
            }
            try {
                IFileStore appStore = this.fileStore.getFileStore((IPath)new Path(path));
                if (!appStore.fetchInfo().exists()) {
                    String msg = NLS.bind((String)"Failed to find application content due to incorrect path parameter: {0}", (Object)appStore.toURI());
                    return new ServerStatus(4, 400, msg, null);
                }
                this.application.setAppStore(appStore);
                this.application.setManifest(manifest);
            }
            catch (Exception exception) {
                return new ServerStatus(4, 400, "Failed to locate application contents as specified in the manifest.", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        catch (ParseException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

