/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class HostedSite
implements IHostedSite {
    private String siteConfigurationId;
    private Map<String, List<String>> mappings;
    private String userId;
    private String workspaceId;
    private String host;
    private String editServer;
    private String url;

    public HostedSite(SiteInfo siteConfig, UserInfo user, String host, String editServer, String url) {
        this.siteConfigurationId = siteConfig.getId();
        this.mappings = Collections.unmodifiableMap(HostedSite.createMap(siteConfig));
        this.userId = user.getUniqueId();
        this.workspaceId = siteConfig.getWorkspace();
        this.host = host;
        this.editServer = editServer;
        this.url = url;
        if (this.userId == null || this.workspaceId == null || this.host == null || this.editServer == null) {
            throw new IllegalArgumentException("Parameters must be nonnull");
        }
    }

    private static Map<String, List<String>> createMap(SiteInfo siteConfig) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        JSONArray mappingsJson = siteConfig.getMappingsJSON();
        int i = 0;
        while (i < mappingsJson.length()) {
            try {
                JSONObject mapping = (JSONObject)mappingsJson.get(i);
                String source = mapping.optString("Source", null);
                String target = mapping.optString("Target", null);
                if (source != null && target != null) {
                    List existingTarget = (List)map.get(source);
                    if (existingTarget != null) {
                        existingTarget.add(target);
                    } else {
                        map.put(source, new ArrayList<String>(Collections.singletonList(target)));
                    }
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        return map;
    }

    public String getSiteConfigurationId() {
        return this.siteConfigurationId;
    }

    public Map<String, List<String>> getMappings() {
        return this.mappings;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getHost() {
        return this.host;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEditServerUrl() {
        return this.editServer;
    }
}

