/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IWebResourceDecorator;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HostedStatusDecorator
implements IWebResourceDecorator {
    private static final String SITE_CONFIGURATION_SERVLET_ALIAS = "site";

    public void addAtributesFor(HttpServletRequest req, URI resource, JSONObject representation) {
        Path path = new Path(req.getPathInfo() == null ? "" : req.getPathInfo());
        if (!"/site".equals(req.getServletPath())) {
            return;
        }
        try {
            UserInfo webUser = HostedStatusDecorator.getWebUser(req);
            if (path.segmentCount() == 0) {
                if ("GET".equals(req.getMethod())) {
                    JSONArray siteConfigurations = representation.optJSONArray("SiteConfigurations");
                    if (siteConfigurations != null) {
                        int i = 0;
                        while (i < siteConfigurations.length()) {
                            this.addStatus(req, siteConfigurations.getJSONObject(i), webUser, resource);
                            ++i;
                        }
                    }
                } else if ("POST".equals(req.getMethod())) {
                    this.addStatus(req, representation, webUser, resource);
                }
            } else if (path.segmentCount() == 1) {
                this.addStatus(req, representation, webUser, resource);
            }
        }
        catch (JSONException e) {
            LogHelper.log((Throwable)e);
        }
    }

    private static UserInfo getWebUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        if (remoteUser != null) {
            try {
                return HostingActivator.getDefault().getMetastore().readUser(remoteUser);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private void addStatus(HttpServletRequest req, JSONObject siteConfigJson, UserInfo user, URI resource) throws JSONException {
        String id = siteConfigJson.optString("Id");
        if (id == null) {
            return;
        }
        SiteInfo siteConfiguration = SiteInfo.getSite((UserInfo)user, (String)id);
        if (siteConfiguration == null) {
            return;
        }
        IHostedSite site = HostingActivator.getDefault().getHostingService().get(siteConfiguration, user);
        JSONObject hostingStatus = new JSONObject();
        if (site != null) {
            try {
                hostingStatus.put("Status", (Object)"started");
                URI uri = new URI(site.getUrl());
                URI newURI = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), req.getContextPath(), null, null);
                hostingStatus.put("URL", (Object)newURI.toString());
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        } else {
            hostingStatus.put("Status", (Object)"stopped");
        }
        siteConfigJson.put("HostingStatus", (Object)hostingStatus);
    }
}

