/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.commands.SetOrgCommand;
import org.eclipse.orion.server.cf.commands.SetSpaceCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONObject;

public class ComputeTargetCommand
implements ICFCommand {
    private String commandName = "Compute Target";
    private String userId;
    private JSONObject targetJSON;
    private Target target;

    public ComputeTargetCommand(String userId, JSONObject targetJSON) {
        this.userId = userId;
        this.targetJSON = targetJSON;
    }

    @Override
    public IStatus doIt() {
        URL targetUrl = null;
        URL manageUrl = null;
        if (this.targetJSON != null) {
            try {
                targetUrl = new URL(this.targetJSON.getString("Url"));
            }
            catch (Exception exception) {}
            try {
                manageUrl = new URL(this.targetJSON.getString("ManageUrl"));
            }
            catch (Exception exception) {}
        }
        this.target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId, targetUrl);
        if (this.target == null) {
            return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
        }
        this.target.getCloud().setManageUrl(manageUrl);
        IStatus result = new SetOrgCommand(this.target, this.targetJSON != null ? this.targetJSON.optString("Org") : null).doIt();
        if (!result.isOK()) {
            return result;
        }
        result = new SetSpaceCommand(this.target, this.targetJSON != null ? this.targetJSON.optString("Space") : null).doIt();
        if (!result.isOK()) {
            return result;
        }
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    public Target getTarget() {
        return this.target;
    }
}

