/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.BindRouteCommand;
import org.eclipse.orion.server.cf.commands.BindServicesCommand;
import org.eclipse.orion.server.cf.commands.CreateApplicationCommand;
import org.eclipse.orion.server.cf.commands.RestartAppCommand;
import org.eclipse.orion.server.cf.commands.UploadBitsCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Push application";
    private App app;
    private boolean force;

    public PushAppCommand(Target target, App app, boolean force) {
        super(target);
        this.app = app;
        this.force = force;
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            if (this.app.getSummaryJSON() == null) {
                CreateApplicationCommand createApplication = new CreateApplicationCommand(this.target, this.app, this.force);
                ServerStatus jobStatus = (ServerStatus)createApplication.doIt();
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return status;
                }
                JSONObject appResp = jobStatus.getJsonData();
                BindRouteCommand bindRoute = new BindRouteCommand(this.target, this.app);
                ServerStatus multijobStatus = (ServerStatus)bindRoute.doIt();
                status.add(multijobStatus);
                if (!multijobStatus.isOK()) {
                    return status;
                }
                UploadBitsCommand uploadBits = new UploadBitsCommand(this.target, this.app);
                multijobStatus = (ServerStatus)uploadBits.doIt();
                status.add(multijobStatus);
                if (!multijobStatus.isOK()) {
                    return status;
                }
                BindServicesCommand bindServices = new BindServicesCommand(this.target, this.app);
                multijobStatus = (ServerStatus)bindServices.doIt();
                status.add(multijobStatus);
                if (!multijobStatus.isOK()) {
                    return status;
                }
                JSONObject result = new JSONObject();
                result.put("Target", (Object)this.target.toJSON());
                if (this.target.getManageUrl() != null) {
                    result.put("ManageUrl", (Object)(String.valueOf(this.target.getManageUrl().toString()) + "#/resources/appGuid=" + this.app.getGuid() + "&orgGuid=" + this.target.getOrg().getGuid() + "&spaceGuid=" + this.target.getSpace().getGuid()));
                }
                result.put("App", (Object)appResp);
                result.put("Domain", (Object)bindRoute.getDomainName());
                result.put("Route", (Object)bindRoute.getRoute());
                status.add(new ServerStatus(Status.OK_STATUS, 200, result));
                return status;
            }
            this.app.setGuid(this.app.getSummaryJSON().getString("guid"));
            UploadBitsCommand uploadBits = new UploadBitsCommand(this.target, this.app);
            ServerStatus multijobStatus = (ServerStatus)uploadBits.doIt();
            status.add(multijobStatus);
            if (!multijobStatus.isOK()) {
                return status;
            }
            RestartAppCommand restartApp = new RestartAppCommand(this.target, this.app);
            multijobStatus = (ServerStatus)restartApp.doIt();
            status.add(multijobStatus);
            if (!multijobStatus.isOK()) {
                return status;
            }
            JSONObject route = this.app.getSummaryJSON().getJSONArray("routes").getJSONObject(0);
            JSONObject result = new JSONObject();
            result.put("Target", (Object)this.target.toJSON());
            if (this.target.getManageUrl() != null) {
                result.put("ManageUrl", (Object)(String.valueOf(this.target.getManageUrl().toString()) + "#/resources/appGuid=" + this.app.getGuid() + "&orgGuid=" + this.target.getOrg().getGuid() + "&spaceGuid=" + this.target.getSpace().getGuid()));
            }
            result.put("App", (Object)this.app.getSummaryJSON());
            result.put("Domain", (Object)route.getJSONObject("domain").getString("name"));
            result.put("Route", (Object)route);
            status.add(new ServerStatus(Status.OK_STATUS, 200, result));
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return status;
        }
    }
}

