/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAppCommand
extends AbstractCFCommand {
    private static final int MAX_ATTEMPTS = 30;
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Start App";
    private App app;

    public StartAppCommand(Target target, App app) {
        super(target);
        this.app = app;
    }

    @Override
    public ServerStatus _doIt() {
        MultiServerStatus result = new MultiServerStatus();
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appUrl = this.app.getAppJSON().getString("url");
            URI appURI = targetURI.resolve(appUrl);
            PutMethod startMethod = new PutMethod(appURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)startMethod, this.target);
            startMethod.setQueryString("inline-relations-depth=1");
            JSONObject startCommand = new JSONObject();
            startCommand.put("console", true);
            startCommand.put("state", (Object)"STARTED");
            StringRequestEntity requestEntity = new StringRequestEntity(startCommand.toString(), "application/json", "UTF-8");
            startMethod.setRequestEntity((RequestEntity)requestEntity);
            ServerStatus startStatus = HttpUtil.executeMethod((HttpMethod)startMethod);
            result.add(startStatus);
            if (!result.isOK()) {
                return result;
            }
            int attemptsLeft = 30;
            String msg = NLS.bind((String)"Can not start the application", (Object)this.commandName);
            ServerStatus getInstancesStatus = new ServerStatus(4, 400, msg, null);
            while (attemptsLeft > 0) {
                Thread.sleep(2000L);
                String appInstancesUrl = String.valueOf(appUrl) + "/instances";
                URI appInstancesURI = targetURI.resolve(appInstancesUrl);
                GetMethod getInstancesMethod = new GetMethod(appInstancesURI.toString());
                HttpUtil.configureHttpMethod((HttpMethod)getInstancesMethod, this.target);
                getInstancesStatus = HttpUtil.executeMethod((HttpMethod)getInstancesMethod);
                if (!getInstancesStatus.isOK()) {
                    --attemptsLeft;
                    continue;
                }
                JSONObject appInstancesJSON = getInstancesStatus.getJsonData();
                int instancesNo = appInstancesJSON.length();
                int runningInstanceNo = 0;
                int flappingInstanceNo = 0;
                Iterator instanceIt = appInstancesJSON.keys();
                while (instanceIt.hasNext()) {
                    JSONObject instanceJSON = appInstancesJSON.getJSONObject((String)instanceIt.next());
                    if ("RUNNING".equals(instanceJSON.optString("state"))) {
                        ++runningInstanceNo;
                        continue;
                    }
                    if (!"FLAPPING".equals(instanceJSON.optString("state"))) continue;
                    ++flappingInstanceNo;
                }
                if (runningInstanceNo == instancesNo || flappingInstanceNo > 0) break;
                --attemptsLeft;
            }
            result.add(getInstancesStatus);
            return result;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

