/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest;

import java.util.LinkedList;
import java.util.Scanner;
import org.eclipse.orion.server.cf.manifest.ManifestNode;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.osgi.util.NLS;

public class ManifestParser {
    private static ManifestNode getFather(LinkedList<ManifestNode> nodes, ManifestNode node) {
        for (ManifestNode father : nodes) {
            if (father.getDepth() >= node.getDepth()) continue;
            return father;
        }
        return null;
    }

    public static ManifestNode parse(Scanner scanner) throws ParseException {
        String input = null;
        int currLine = 0;
        while (scanner.hasNextLine()) {
            input = ManifestUtils.removeComments(scanner.nextLine());
            ++currLine;
            if ("---".equals(input.trim())) {
                input = null;
                continue;
            }
            if (input.length() > 0) break;
            input = null;
        }
        if (input == null || input.length() == 0) {
            throw new ParseException("Unexpected empty line", currLine + 1);
        }
        int depth = ManifestUtils.getDepth(input);
        ManifestNode tree = new ManifestNode(input, depth, currLine);
        LinkedList<ManifestNode> nodeList = new LinkedList<ManifestNode>();
        nodeList.addFirst(tree);
        while (scanner.hasNextLine()) {
            ManifestNode node;
            ManifestNode father;
            input = ManifestUtils.removeComments(scanner.nextLine());
            depth = ManifestUtils.getDepth(input);
            ++currLine;
            if (input.length() == 0) continue;
            if (ManifestUtils.isSequenceItem(input)) {
                depth += 2;
            }
            if ((father = ManifestParser.getFather(nodeList, node = new ManifestNode(input, depth, currLine))) == null) {
                throw new ParseException(NLS.bind((String)"Unexpected token \"{0}\" (possibly invalid indentation)", (Object)input), currLine);
            }
            father.getChildren().add(node);
            nodeList.addFirst(node);
        }
        return tree;
    }
}

