/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest;

import java.net.URI;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ManifestUtils {
    public static final String MANIFEST_FILE_NAME = "manifest.yml";
    private static final Pattern pattern = Pattern.compile("[^ ]");
    private static final String MANIFEST_TARGET_BASE_SYMBOL = "${target-base}";
    private static final String MANIFEST_TARGET_BASE_SYMBOL_PATTERN = "\\$\\{target-base\\}";
    private static final String MANIFEST_RANDOM_WORD_SYMBOL = "${random-word}";
    private static final String MANIFEST_RANDOM_WORD_SYMBOL_PATTERN = "\\$\\{random-word\\}";

    static String removeComments(String input) {
        return input.split("#")[0];
    }

    static boolean isSequenceItem(String input) {
        return input.trim().startsWith("- ");
    }

    static String[] splitLabel(String input) {
        int idx = input.indexOf(":");
        String head = null;
        String tail = null;
        if (idx != -1) {
            head = input.substring(0, idx);
            tail = input.substring(idx + 1);
            tail = tail.trim();
        } else {
            head = input;
        }
        if (head.startsWith("- ")) {
            head = head.substring(2);
        }
        String[] sLabel = tail != null && !tail.isEmpty() ? new String[]{head, tail} : new String[]{head};
        return sLabel;
    }

    static int getDepth(String input) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.start();
        }
        return 0;
    }

    public static int getMemoryLimit(String input) {
        return !input.isEmpty() ? Integer.parseInt(input.split("M")[0]) : 128;
    }

    public static int getInstances(String input) {
        return !input.isEmpty() ? Integer.parseInt(input) : 1;
    }

    static String resolve(String input, URI target) {
        if (target == null) {
            return input;
        }
        if (input.contains(MANIFEST_TARGET_BASE_SYMBOL)) {
            String targetBase = target.getHost().substring(4);
            input = input.replaceAll(MANIFEST_TARGET_BASE_SYMBOL_PATTERN, targetBase);
        }
        if (input.contains(MANIFEST_RANDOM_WORD_SYMBOL)) {
            String randomWord = UUID.randomUUID().toString();
            input = input.replaceAll(MANIFEST_RANDOM_WORD_SYMBOL_PATTERN, randomWord);
        }
        return input;
    }

    static String normalize(String input) {
        boolean endingQuot;
        boolean openingQuot = input.startsWith("\"") || input.startsWith("'");
        boolean bl = endingQuot = input.endsWith("\"") || input.endsWith("'");
        if (openingQuot && endingQuot) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static JSONObject getApplication(JSONObject manifest) throws ParseException {
        try {
            return manifest.getJSONArray("applications").getJSONObject(0);
        }
        catch (JSONException jSONException) {
            throw new ParseException("No applications listed in the manifest (possibly missing dash \"- \")");
        }
    }

    public static String getApplicationName(JSONObject application) throws ParseException {
        try {
            return application.getString("name");
        }
        catch (JSONException jSONException) {
            throw new ParseException("The application does not have a \"name\" property");
        }
    }

    public static JSONObject getJSON(JSONObject parent, String child, String parentName) throws ParseException {
        try {
            return parent.getJSONObject(child);
        }
        catch (JSONException jSONException) {
            throw new ParseException(NLS.bind((String)"Cannot find group \"{0}\" within {1} (possibly missing new-line)", (Object)child, (Object)parentName));
        }
    }

    public static JSONArray getJSONArray(JSONObject parent, String child, String parentName) throws ParseException {
        try {
            return parent.getJSONArray(child);
        }
        catch (JSONException jSONException) {
            throw new ParseException(NLS.bind((String)"Cannot find group \"{0}\" within {1} (possibly missing new-line)", (Object)child, (Object)parentName));
        }
    }

    public static String getString(JSONObject parent, String child, String parentName) throws ParseException {
        try {
            return parent.getString(child);
        }
        catch (JSONException jSONException) {
            throw new ParseException(NLS.bind((String)"Cannot find property \"{0}\" within {1}", (Object)child, (Object)parentName));
        }
    }
}

