/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.orion.internal.server.hosting.HostedSite;
import org.eclipse.orion.internal.server.hosting.SiteHostingConfig;
import org.eclipse.orion.internal.server.servlets.hosting.IHostedSite;
import org.eclipse.orion.internal.server.servlets.hosting.ISiteHostingService;
import org.eclipse.orion.internal.server.servlets.hosting.NoMoreHostsException;
import org.eclipse.orion.internal.server.servlets.hosting.SiteHostingException;
import org.eclipse.orion.internal.server.servlets.site.SiteInfo;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;

public class SiteHostingService
implements ISiteHostingService {
    private final SiteHostingConfig config;
    private ConcurrentMap<String, IHostedSite> sites;

    public SiteHostingService(SiteHostingConfig config) {
        this.config = config;
        this.sites = new ConcurrentHashMap<String, IHostedSite>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SiteInfo siteConfig, UserInfo user, String editServer, URI requestURI) throws SiteHostingException {
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            if (this.get(siteConfig, user) != null) {
                return;
            }
            String host = null;
            try {
                URI url = this.acquireURL(siteConfig.getHostHint(), requestURI);
                host = url.getHost();
                IHostedSite result = this.sites.putIfAbsent(host, new HostedSite(siteConfig, user, host, editServer, url.toString()));
                if (result != null) {
                    throw new ConcurrentModificationException("Table was modified concurrently");
                }
            }
            catch (Exception e) {
                if (host != null) {
                    this.sites.remove(host);
                }
                throw new SiteHostingException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(SiteInfo siteConfig, UserInfo user) throws SiteHostingException {
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            IHostedSite site = this.get(siteConfig, user);
            if (site == null) {
                return;
            }
            if (!this.sites.remove(site.getHost(), site)) {
                throw new ConcurrentModificationException("Table was modified concurrently");
            }
        }
    }

    public IHostedSite get(SiteInfo siteConfig, UserInfo user) {
        String id = siteConfig.getId();
        String userId = user.getUniqueId();
        for (IHostedSite site : this.sites.values()) {
            if (!site.getSiteConfigurationId().equals(id) || !site.getUserId().equals(userId)) continue;
            return site;
        }
        return null;
    }

    public boolean isHosted(String host) {
        return this.get(host) != null;
    }

    public boolean matchesVirtualHost(String host) {
        List<String> hosts = this.config.getHosts();
        for (String h : hosts) {
            if (h.equals(host)) {
                return true;
            }
            try {
                HostPattern pattern = this.getHostPattern(h, new URI("http", null, host, -1, null, null, null));
                String configHost = pattern.getHost();
                if (configHost == null || !host.endsWith(configHost.replace("*", ""))) continue;
                return true;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return false;
    }

    IHostedSite get(String host) {
        return (IHostedSite)this.sites.get(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI acquireURL(String hint, URI requestURI) throws NoMoreHostsException {
        hint = hint == null || hint.equals("") ? "site" : hint;
        ConcurrentMap<String, IHostedSite> concurrentMap = this.sites;
        synchronized (concurrentMap) {
            URI result = null;
            for (String value : this.config.getHosts()) {
                try {
                    HostPattern pattern = this.getHostPattern(value, requestURI);
                    String host = pattern.getHost();
                    if (pattern.isWildcard()) {
                        String rest = "." + pattern.getWildcardDomain();
                        String candidate = String.valueOf(hint) + rest;
                        int i = 0;
                        while (this.isHosted(candidate)) {
                            candidate = String.valueOf(hint) + Integer.toString(i) + rest;
                            ++i;
                        }
                        result = new URI(pattern.getScheme(), null, candidate, pattern.getPort(), null, null, null);
                        break;
                    }
                    if (this.isHosted(host)) continue;
                    result = new URI(pattern.getScheme(), null, host, pattern.getPort(), null, null, null);
                    break;
                }
                catch (URISyntaxException e) {
                    LogHelper.log((Throwable)e);
                }
            }
            if (result == null) {
                throw new NoMoreHostsException("No more hosts available");
            }
            return result;
        }
    }

    private HostPattern getHostPattern(String pattern, URI requestURI) {
        String scheme = null;
        int port = -1;
        if (pattern.startsWith("http://") || pattern.startsWith("https://")) {
            int schemeEnd = pattern.indexOf("://");
            scheme = pattern.substring(0, schemeEnd);
            pattern = pattern.substring(schemeEnd + "://".length(), pattern.length());
            if ("https".equals(scheme)) {
                port = 443;
            } else if ("http".equals(scheme)) {
                port = 80;
            }
        }
        String hostPart = pattern;
        int pos = pattern.lastIndexOf(":");
        if (pos != -1 && pos < pattern.length() - 1) {
            hostPart = pattern.substring(0, pos);
            try {
                port = Integer.parseInt(pattern.substring(pos + 1, pattern.length()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (scheme == null) {
            scheme = requestURI.getScheme();
        }
        if (port == -1) {
            port = requestURI.getPort();
        }
        return new HostPattern(scheme, hostPart, this.defaultPort(scheme, port));
    }

    private int defaultPort(String scheme, int port) {
        if ("https".equals(scheme) && port == 443 || "http".equals(scheme) && port == 80) {
            return -1;
        }
        return port;
    }

    private class HostPattern {
        private String scheme;
        private String host;
        private int port;
        private boolean isWildcard = false;
        private String wildcardDomain = null;

        public HostPattern(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            if (host != null) {
                int pos = host.lastIndexOf("*");
                boolean bl = this.isWildcard = pos >= 0 && pos < host.length() - 2 && host.charAt(pos + 1) == '.';
                if (this.isWildcard) {
                    this.wildcardDomain = host.substring(pos + 2, host.length());
                }
            }
        }

        String getScheme() {
            return this.scheme;
        }

        String getHost() {
            return this.host;
        }

        String getWildcardDomain() {
            return this.wildcardDomain;
        }

        int getPort() {
            return this.port;
        }

        boolean isWildcard() {
            return this.isWildcard;
        }
    }
}

