/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.DeleteApplicationCommand;
import org.eclipse.orion.server.cf.commands.DeleteApplicationRoutesCommand;
import org.eclipse.orion.server.cf.manifest.ManifestUtils;
import org.eclipse.orion.server.cf.manifest.ParseException;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateApplicationCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Create a new application";
    private App application;
    private String appName;
    private String appCommand;
    private int appInstances;
    private int appMemory;
    private String buildPack;
    private boolean force;

    public CreateApplicationCommand(Target target, App app, boolean force) {
        super(target);
        this.application = app;
        this.force = force;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            if (this.force) {
                DeleteApplicationCommand deleteApplicationCommand = new DeleteApplicationCommand(this.target, this.application);
                deleteApplicationCommand.doIt();
                DeleteApplicationRoutesCommand deleteRouteCommand = new DeleteApplicationRoutesCommand(this.target, this.application);
                deleteRouteCommand.doIt();
            }
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI appsURI = targetURI.resolve("/v2/apps");
            PostMethod createAppMethod = new PostMethod(appsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)createAppMethod, this.target);
            JSONObject createAppRequst = new JSONObject();
            createAppRequst.put("space_guid", (Object)this.target.getSpace().getCFJSON().getJSONObject("metadata").getString("guid"));
            createAppRequst.put("name", (Object)this.appName);
            createAppRequst.put("instances", this.appInstances);
            createAppRequst.put("buildpack", this.buildPack != null ? this.buildPack : JSONObject.NULL);
            createAppRequst.put("command", (Object)this.appCommand);
            createAppRequst.put("memory", this.appMemory);
            createAppRequst.put("stack_guid", JSONObject.NULL);
            createAppMethod.setRequestEntity((RequestEntity)new StringRequestEntity(createAppRequst.toString(), "application/json", "utf-8"));
            ServerStatus status = HttpUtil.executeMethod((HttpMethod)createAppMethod);
            if (!status.isOK()) {
                return status;
            }
            JSONObject appResp = status.getJsonData();
            this.application.setGuid(appResp.getJSONObject("metadata").getString("guid"));
            this.application.setName(this.appName);
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            JSONObject appJSON = ManifestUtils.getApplication(this.application.getManifest());
            this.appName = ManifestUtils.getApplicationName(appJSON);
            this.appCommand = appJSON.optString("command");
            this.appInstances = ManifestUtils.getInstances(appJSON.optString("instances"));
            String mem = appJSON.optString("memory");
            if (mem.equals("")) {
                mem = appJSON.optString("mem");
            }
            this.appMemory = ManifestUtils.getMemoryLimit(mem);
            this.buildPack = appJSON.optString("buildpack", null);
            return Status.OK_STATUS;
        }
        catch (ParseException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

