/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.commands.ParseManifestCommand;
import org.eclipse.orion.server.cf.commands.PushAppCommand;
import org.eclipse.orion.server.cf.commands.StartAppCommand;
import org.eclipse.orion.server.cf.commands.StopAppCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsHandlerV1
extends AbstractRESTHandler<App> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public AppsHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected App buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(App app, HttpServletRequest request, HttpServletResponse response, final String path) {
        final String contentLocation = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"ContentLocation");
        final String name = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Name");
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus result = computeTarget.doIt();
                    if (!result.isOK()) {
                        return result;
                    }
                    Target target = computeTarget.getTarget();
                    if (contentLocation != null || name != null) {
                        return new GetAppCommand(target, name).doIt();
                    }
                    return AppsHandlerV1.this.getApps(target);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePut(App resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        JSONObject jsonData = this.extractJSONData(request);
        final String state = jsonData.optString("State");
        final String appName = jsonData.optString("Name");
        final JSONObject targetJSON = jsonData.optJSONObject("Target");
        final String contentLocation = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)jsonData.optString("ContentLocation"));
        final boolean force = jsonData.optBoolean("Force", true);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus status = computeTarget.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    Target target = computeTarget.getTarget();
                    GetAppCommand getAppCommand = new GetAppCommand(target, appName);
                    status = getAppCommand.doIt();
                    App app = getAppCommand.getApp();
                    if ("Started".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StartAppCommand(target, app).doIt();
                    }
                    if ("Stopped".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StopAppCommand(target, app).doIt();
                    }
                    if (app == null) {
                        app = new App();
                    }
                    app.setName(appName);
                    ParseManifestCommand parseManifestCommand = new ParseManifestCommand(target, app, this.userId, contentLocation);
                    status = parseManifestCommand.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    status = new PushAppCommand(target, app, force).doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    getAppCommand = new GetAppCommand(target, app.getName());
                    getAppCommand.doIt();
                    app = getAppCommand.getApp();
                    new StartAppCommand(target, app).doIt();
                    return status;
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    private IStatus getApps(Target target) throws Exception {
        String appsUrl = target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
        appsUrl = appsUrl.replaceAll("apps", "summary");
        URI appsURI = URIUtil.toURI((URL)target.getUrl()).resolve(appsUrl);
        GetMethod getMethod = new GetMethod(appsURI.toString());
        HttpUtil.configureHttpMethod((HttpMethod)getMethod, target);
        return HttpUtil.executeMethod((HttpMethod)getMethod);
    }
}

