/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.GetLogsCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Log;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogsHandlerV1
extends AbstractRESTHandler<Log> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public LogsHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Log buildResource(HttpServletRequest request, String pathString) throws CoreException {
        if (pathString == null) {
            return null;
        }
        Path path = new Path(pathString);
        return new Log(path.segment(0), path.segment(1));
    }

    @Override
    protected CFJob handleGet(final Log resource, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus result = computeTarget.doIt();
                    if (!result.isOK()) {
                        return result;
                    }
                    Target target = computeTarget.getTarget();
                    if (target.getSpace() == null) {
                        String msg = "Space not set";
                        return new ServerStatus(4, 404, msg, null);
                    }
                    if (resource.getApplication() != null) {
                        return new GetLogsCommand(target, resource.getApplication(), resource.getName(), this.requestLocation).doIt();
                    }
                    return new ServerStatus(4, 404, "No application name", null);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    LogsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

